<?php
namespace Dalten\WebBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GenerateEntitiesCommand extends ContainerAwareCommand
{

    protected $classTemplate = <<<TPL
<?php
namespace FrontBundle\Entity;
use Dalten\WebBundle\Entity\ParentEntity as WebParentEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="table_name")
 */
class EntityName extends WebParentEntity
{
}
TPL;

    protected function configure()
    {
        $this
            ->setName('web:generate-entities')
            ->setDescription('Generates FrontBundle entities for dalten/web')
            ->addOption('force', null, null, 'Overwrite existing entities.')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $srcDir = realpath($this->getContainer()->get('kernel')->getRootDir() . '/../src');
        $entityDir = $srcDir . '/FrontBundle/Entity';

        if (!is_dir($entityDir)) {
            mkdir($entityDir, true);
        }


        $entities = [
            'uzivatel'=>'Broker',
            'firma'=>'Company',
            'projekt'=>'DevProject', 
            'nabidka'=>'Listing',
        ];

        foreach ($entities as $tableName=>$entity) {
            $entityFileName = $entityDir . '/' . $entity . '.php';
            $entityContent = str_replace(
                ['EntityName', 'ParentEntity', 'table_name'],
                [$entity, $entity, $tableName],
                $this->classTemplate
            );

            if (file_exists($entityFileName) && !$input->getOption('force')) {
                $output->writeln(sprintf('ERROR - entity %s already exists. Use --force to overwrite entities.', $entity));
                return 1;
            }

            if (file_put_contents($entityFileName, $entityContent) === false) {
                $output->writeln(sprintf('Error - cannot write file "%s"', $entityFileName));
                return 1;
            }
        }

        $output->writeln(sprintf('%d entities written.', count($entities)));
        return 0;
    }
}
