<?php
namespace Dalten\WebBundle\DependencyInjection\Feature;

use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 14.04.2016
 * Time: 10:58
 */
class ListingListTitleGenerator implements FeatureInterface
{
	public function load(array $featureConfig, ContainerBuilder $container)
	{
		$loader = new YamlFileLoader(
			$container,
			new FileLocator(__DIR__ . '/../../Resources/config/feature/listing_list_title_generator')
		);
		$loader->load('config.yml');

		if (isset($featureConfig['codebooks']) && is_array($featureConfig['codebooks'])) {
			$codebooks = array_merge(
				$container->getParameter('_title_generator.listing_list.codebooks'),
				$featureConfig['codebooks']
			);

			$container->setParameter('_title_generator.listing_list.codebooks', $codebooks);
		}

		if (isset($featureConfig['all_counties_title'])) {
			$container->setParameter(
				'_title_generator.listing_list.all_counties_title', $featureConfig['all_counties_title']
			);
		}

		if (isset($featureConfig['special_titles']) && is_array($featureConfig['special_titles'])) {
			$container->setParameter(
				'_title_generator.listing_list.special_titles', $featureConfig['special_titles']
			);
		}

		if (isset($featureConfig['other_listing_type_ids']) && is_array($featureConfig['other_listing_type_ids'])) {
			$container->setParameter(
				'_title_generator.listing_list.other_listing_type_ids', $featureConfig['other_listing_type_ids']
			);
		}
	}
}
