<?php

namespace Dalten\WebBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entita přílohy (fotka / dokument).
 *
 * @property int    $parent_id       Id rodičovského prvku.
 * @property int    $parent_type     Typ rodičovského prvku (konstanty třídy).
 * @property int    $attachment_type Typ přílohy (konstanty třídy).
 * @property int    $category_id     Id kategorie dokumentu.
 * @property string $file_name       Název souboru (původní).
 * @property string $path            Relativní cesta k souboru.
 * @property int    $width           Šířka fotky.
 * @property int    $height          Výška fotky.
 * @property string $description     Popis přílohy.
 * @property int    $order           Pořadí přílohy.
 * 
 * @ORM\InheritanceType( "SINGLE_TABLE" )
 * @ORM\DiscriminatorColumn( name = "typ_parent", type = "integer" )
 * @ORM\DiscriminatorMap( { "2" = "DevProjectAttachment", "1" = "ListingAttachment" } )
 * 
 * @ORM\Table(name="priloha", indexes={@ORM\Index(name="id_parent", columns={"id_parent", "typ_parent", "typ_prilohy"})})
 * @ORM\Entity
 */
abstract class Attachment implements EntityWithLegacyData
{
	use LegacyDataMethods;

	const TYPE_IMAGE = 1;
	const TYPE_DOCUMENT = 2;

	const PARENT_TYPE_LISTING = 1;
	const PARENT_TYPE_DEV_PROJECT = 2;

	/**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_parent", type="integer", nullable=false)
     */
    private $_id_parent;

    /**
     * @var integer
     */
    private $_typ_parent;

    /**
     * @var integer
     *
     * @ORM\Column(name="typ_prilohy", type="integer", nullable=false)
     */
    private $_typ_prilohy;

    /**
     * @var integer
     *
     * @ORM\Column(name="typ_kategorie", type="integer", nullable=false)
     */
    private $_typ_kategorie;

    /**
     * @var string
     *
     * @ORM\Column(name="nazev_souboru", type="string", length=100, nullable=false)
     */
    private $_nazev_souboru;

    /**
     * @var string
     *
     * @ORM\Column(name="soubor", type="string", length=200, nullable=false)
     */
    private $_soubor;

    /**
     * @var integer
     *
     * @ORM\Column(name="width", type="integer", nullable=false)
     */
    private $_width;

    /**
     * @var integer
     *
     * @ORM\Column(name="height", type="integer", nullable=false)
     */
    private $_height;

    /**
     * @var string
     *
     * @ORM\Column(name="popis", type="string", length=200, nullable=false)
     */
    private $_popis;

    /**
     * @var integer
     *
     * @ORM\Column(name="poradi", type="integer", nullable=false)
     */
    private $_poradi;

	private static $_map = array(
		'parent_id' => '_id_parent',
		'parent_type' => '_typ_parent',
		'attachment_type' => '_typ_prilohy',
		'category_id' => '_typ_kategorie',
		'file_name' => '_nazev_souboru',
		'path' => '_soubor',
		'width' => '_width',
		'height' => '_height',
		'description' => '_popis',
		'order' => '_poradi',
	);

	public function isImage()
	{
		return $this->_typ_prilohy === self::TYPE_IMAGE;
	}

	public function isDocument()
	{
		return $this->_typ_prilohy === self::TYPE_DOCUMENT;
	}
}

