<?php

namespace Dalten\WebBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entita proměnné.
 *
 * Obsahuje základní informace o proměnné a případně i data o jejím číselníku.
 *
 * @property int    $id            Identifikátor proměnné.
 * @property int    $category_id   ID kategorie.
 * @property string $variable_name Název proměnné.
 * @property string $label_czech   Český label.
 * @property string $label_english Anglický label.
 * @property string $label_slovak  Slovenský label.
 * @property int    $type          Typ proměnné.
 * 
 * @ORM\Table(name="variables")
 * @ORM\MappedSuperclass
 */
class Variable implements EntityWithLegacyData
{
	use LegacyDataMethods;

	const TYPE_SELECT = 1;
	const TYPE_MULTICHECKBOX = 2;
	const TYPE_CHECKBOX = 3;
	const TYPE_MEMO = 4;
	const TYPE_SHORT_TEXT = 5;
	const TYPE_INT = 6;
	const TYPE_INT_METERS = 7;
	const TYPE_INT_SQUARE_METERS = 8;
	const TYPE_FLOAT = 9;
	const TYPE_DATE = 10;
	const TYPE_TIME = 11;
	const TYPE_IMAGE = 12;
	const TYPE_IMAGE_BUTTON = 13;
	const TYPE_BUTTON = 14;
	const TYPE_YESNO = 15;
	const TYPE_YESNOQUESTION = 16;
	const TYPE_YESNOAREA = 17;
	const TYPE_CURRENCY = 18;

	/**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

	/**
     * @var integer
     *
     * @ORM\Column(name="id_category", type="integer", nullable=false)
     */
    private $_id_category;

    /**
     * @var string
     *
     * @ORM\Column(name="var_name", type="string", length=50, nullable=true)
     */
    private $_var_name;

    /**
     * @var string
     *
     * @ORM\Column(name="input_name", type="string", length=64, nullable=false)
     */
    private $_input_name;

    /**
     * @var string
     *
     * @ORM\Column(name="table_name", type="string", length=200, nullable=false)
     */
    private $_table_name;

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-czech`", type="string", length=100, nullable=true)
     */
    private $_lang_czech;

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-english`", type="string", length=100, nullable=true)
     */
    private $_lang_english;

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-slovak`", type="string", length=100, nullable=true)
     */
    private $_lang_slovak;

    /**
     * @var string
     *
     * @ORM\Column(name="`help-czech`", type="text", length=65535, nullable=false)
     */
    private $_help_czech;

    /**
     * @var string
     *
     * @ORM\Column(name="`help-english`", type="text", length=65535, nullable=false)
     */
    private $_help_english;

    /**
     * @var string
     *
     * @ORM\Column(name="`help-slovak`", type="text", length=65535, nullable=true)
     */
    private $_help_slovak;

    /**
     * @var string
     *
     * @ORM\Column(name="`error-czech`", type="string", length=250, nullable=true)
     */
    private $_error_czech;

    /**
     * @var string
     *
     * @ORM\Column(name="`error-english`", type="string", length=250, nullable=true)
     */
    private $_error_english;

    /**
     * @var string
     *
     * @ORM\Column(name="`error-slovak`", type="string", length=255, nullable=true)
     */
    private $_error_slovak;

    /**
     * @var integer
     *
     * @ORM\Column(name="type", type="integer", nullable=false)
     */
    private $_type;

    /**
     * @var boolean
     *
     * @ORM\Column(name="locked", type="boolean", nullable=true)
     */
    private $_locked;

    /**
     * @var string
     *
     * @ORM\Column(name="javaid", type="string", length=64, nullable=true)
     */
    private $_javaid;

    /**
     * @var string
     *
     * @ORM\Column(name="onchange", type="string", length=255, nullable=true)
     */
    private $_onchange;

    /**
     * @var string
     *
     * @ORM\Column(name="onclick", type="string", length=255, nullable=true)
     */
    private $_onclick;

    /**
     * @var string
     *
     * @ORM\Column(name="style", type="string", length=255, nullable=true)
     */
    private $_style;

    /**
     * @var integer
     *
     *
     * @ORM\Column(name="min", type="integer", nullable=false)
     */
    private $_min = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="max", type="integer", nullable=false)
     */
    private $_max = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="ereg", type="string", length=200, nullable=true)
     */
    private $_ereg;

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-russian`", type="string", length=100, nullable=false)
     */
    private $_lang_russian;

	/**
	 * @var array
     * 
     * @ORM\OneToMany(targetEntity="VariableListValue", mappedBy="variable")
	 */
	private $listValues;

	private static $_map = array(
		'category_id' => '_id_category',
		'variable_name' => '_var_name',
		'label_czech' => '_lang_czech',
		'label_english' => '_lang_english',
		'label_slovak' => '_lang_slovak',
		'label_russian' => '_lang_russian',
		'type' => '_type',
	);

	/**
	 * @var array Cache na seřazené list values.
	 */
	private $_indexedListValues = null;

	/**	 *
	 * @return VariableListValue[]
	 */
	public function getListValues()
	{
		return $this->listValues;
	}

	/**
	 * @param VariableListValue[] $listValues
	 *
	 * @return $this
	 */
	public function setListValues(array $listValues)
	{
		$this->listValues = $listValues;

		$this->_indexedListValues = null;

		return $this;
	}

	/**
	 * Vrátí entitu listValue pro danou hodnotu a nebo null.
	 *
	 * Listvalue musí být viditelná (visible), aby byla vrácena.
	 *
	 * @param mixed $value Hodnota proměnné (value v ListValue).
	 *
	 * @return VariableListValue|null
	 */
	public function getListValueByValue($value)
	{
		$this->_prepareListValues();

		return isset($this->_indexedListValues[$value]) ? $this->_indexedListValues[$value] : null;
	}

	/**
	 * Získá číselník jako asociativní pole.
	 *
	 * @param string $labelPropertyName Název pole s labelem (lang_czech).
	 *
	 * @return array Asociativní pole číselníku ([value] => [label]).
	 */
	public function getCodebook($labelPropertyName = 'label_czech')
	{
		$this->_prepareListValues();

		return array_map(
				function(VariableListValue $listValue) use ($labelPropertyName) {
					return $listValue->$labelPropertyName;
				},
				$this->_indexedListValues
		);
	}

	/**
	 * Připraví indexované pole ListValues.
	 *
	 * Funkce se provede pouze pokud je třeba, jinak se výsledek cachuje.
	 */
	private function _prepareListValues()
	{
		if (isset($this->_indexedListValues)) {
			return;
		}

		foreach ($this->getListValues() as $listValue) {
			$this->_indexedListValues[$listValue->value] = $listValue;
		}

		if ($this->_indexedListValues) {
			uasort($this->_indexedListValues, function ($firstVar, $secondVar) {
				/** @var $firstVar VariableListValue */
				/** @var $secondVar VariableListValue */
				return $firstVar->order > $secondVar->order ? 1 : -1;
			});
		}
	}
}

