<?php
namespace Dalten\WebBundle\Filter;

use Dalten\WebBundle\Filter\Exception\InvalidAddressFilter;

/**
 * Normalizovaný filtr na vyhledávání kanceláří.
 *
 * @property string $search_text Vyhledávaný text.
 */
class CompanyFilter extends Base implements FilterWithAddressInterface
{
  /**
   * Asociativní pole názvů (klíče) a datových typů (hodnoty) prvků filtru.
   */
  private $_properties = array(
		'search_text' => 'string',
  );

	/**
	 * Pole předaných adresních filtrů.
	 *
	 * @var AddressFilter[]
	 */
	private $_addressFilters = array();

	/**
	 * Inicializuje data filtru a uloží předané adresní filtry.
	 *
	 * @param array           $data           Pole (již přeložených) dat filtru.
	 * @param AddressFilter[] $addressFilters Pole naplněných adresních filtrů.
	 *
	 * @throws InvalidAddressFilter Pokud je v poli $addressFilters jiný prvek než třídy AddressFilter.
	 */
	public function __construct(array $data, array $addressFilters = array())
	{
		$normalizedData = $this->_normalizeData($this->_properties, $data);

		foreach ($addressFilters as $filter) {
			if (!($filter instanceof AddressFilter)) {
				throw new InvalidAddressFilter('Předané adresní filtry musí být instancemi AddressFilter');
			}
		}
		$this->_addressFilters = $addressFilters;

		parent::__construct($normalizedData);
	}

	/**
	 * Vrátí předané adresní filtry.
	 *
	 * @return AddressFilter[]
	 */
	public function getAddressFilters()
	{
		return $this->_addressFilters;
	}
}
