<?php

namespace Dalten\WebBundle\Processor\Favourite;

/**
 * Rozhraní pro adapter oblíbených nabidek.
 *
 * @package Dalten\WebBundle\Processor\Favourite
 */
interface StorageInterface
{
	/**
	 * Vrátí pole identifikátorů nabídek.
	 *
	 * @return array
	 */
	public function getListingIds();

	/**
	 * Přidá nabídky do oblíbených.
	 *
	 * @param array $ids Pole identifikátorů nabídek.
	 */
	public function addListings(array $ids);

	/**
	 * Smaže nabídky z oblíbených.
	 *
	 * @param array $ids Pole identifikátorů nabídek.
	 */
	public function delListings(array $ids);
}
 