<?php
namespace Dalten\WebBundle\Processor\TitleGenerator\ListingList;

use Dalten\WebBundle\Filter\ListingFilter;

/**
 * Složený generátor na obecné titulky k výpisům nemovitostí.
 *
 * Vytváří titulky pomocí generátorů, které mu jsou předány. Takto je možné mít speciální generátory jen na některé
 * typy nemovitostí.
 */
class Composite implements GeneratorInterface
{
	/**
	 * Pole vnitřních generátorů.
	 *
	 * @var GeneratorInterface[]
	 */
	private $_generators;

	/**
	 * Nastavuje pole vnitřních generátorů.
	 *
	 * @param GeneratorInterface[] $generators
	 */
	function __construct(array $generators)
	{
		$this->_generators = $generators;
	}

	/**
	 * Vytvoří z předaného filtru titulek pro výpis.
	 *
	 * Titulek se vytváří postupným iterováním vnitřních generátorů. Pokud generátor vrátí prázdný titulek,
	 * zkusí se další generátor. První neprázdný titulek je vrácen.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return string Vytvořený titulek pro filtr.
	 */
	public function createTitle(ListingFilter $filter)
	{
		foreach ($this->_generators as $generator) {
			$title = $generator->createTitle($filter);

			if ($title) {
				return $title;
			}
		}

		return '';
	}
}
