<?php
namespace Dalten\WebBundle\SeoRoute\Matcher\ListingFilter;

use Dalten\WebBundle\Filter\ListingFilter;

/**
 * Matcher, který převádí omezení na cenu na parametry routy.
 */
class PriceFragmentMatcher implements FragmentMatcherInterface
{
	/**
	 * Název parametru routy, který obsahuje minimální cenu.
	 *
	 * @var string
	 */
	private $_minPriceRouteParamName;
	/**
	 * Název parametru routy, který obsahuje maximální cenu.
	 *
	 * @var string
	 */
	private $_maxPriceRouteParamName;

	/**
	 * Nastavuje konfiguraci matcheru.
	 *
	 * @param string $minPriceRouteParamName Název parametru routy, který obsahuje minimální cenu.
	 * @param string $maxPriceRouteParamName Název parametru routy, který obsahuje maximální cenu.
	 */
	public function __construct($minPriceRouteParamName, $maxPriceRouteParamName)
	{
		$this->_minPriceRouteParamName = $minPriceRouteParamName;
		$this->_maxPriceRouteParamName = $maxPriceRouteParamName;
	}

	/**
	 * Vrací pole parametrů pro routu, obsahující matchnutou část filtru.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return array Pole parametrů nalezené routy a nebo prázdné pole.
	 */
	public function getRouteParamsForFilter(ListingFilter $filter)
	{
		$params = $this->_getRouteParams($filter);
		return array_filter($params);
	}

	/**
	 * Vrátí pole názvů vlastností filtru, které byly zpracovány tímto fragmentem pro daný filtr.
	 *
	 * Vrací prázdné pole, pokud daný filtr není pokryt.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return array Pole názvů vlastností filtru, byly zpracovány tímto fragmentem pro daný filtr.
	 */
	public function getMatchedFilterParamsForFilter(ListingFilter $filter)
	{
		$routeParams = $this->_getRouteParams($filter);
		$filterParams = array();

		if (!empty($routeParams[$this->_minPriceRouteParamName])) {
			$filterParams[] = 'price_min';
		}
		if (!empty($routeParams[$this->_maxPriceRouteParamName])) {
			$filterParams[] = 'price_max';
		}

		return $filterParams;
	}

	/**
	 * Projede pole $_config a hledá, zda některá z jeho hodnot odpovídá předanému filtru.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return null|string Název nalezeného slugu a nebo null.
	 */
	protected function _getRouteParams(ListingFilter $filter)
	{
		$params = array($this->_minPriceRouteParamName => null, $this->_maxPriceRouteParamName => null);
		if ($filter->price_min) {
			$params[$this->_minPriceRouteParamName] = $filter->price_min;
		}

		if ($filter->price_max) {
			$params[$this->_maxPriceRouteParamName] = $filter->price_max;
		}

		return $params;
	}
}

