<?php
namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\BrokerFilter;
use Dalten\WebBundle\Entity\Broker;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Broker\Builder\BrokerListAndCountyAndRegion;
use Mockery as m;

class BrokerListAndCountyAndRegionTest extends \PHPUnit_Framework_TestCase
{

	public function testBuilderCannotCreateBreadcrumbFromBrokerModel()
	{
		$Broker = new Broker();

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$helper->shouldReceive('getBreadcrumb')->never();
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\BrokerListAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromBroker')->never();
		$builder = new BrokerListAndCountyAndRegion($previousBuilder, $helper);

		$this->assertNull($builder->getBreadcrumbFromBroker($Broker));
	}

	public function testBuilderCannotCreateBreadcrumbIfCountyBreadcrumbIsNotSet()
	{
		$filter = new BrokerFilter(array(), array(new AddressFilter(5, array(55))));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->never();
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\BrokerListAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn(null);
		$builder = new BrokerListAndCountyAndRegion($previousBuilder, $helper);

		$this->assertNull($builder->getBreadcrumbFromFilter($filter));
	}

	public function testBuilderPassesCorrectParametersToHelperAndReturnsResult()
	{
		$filter = new BrokerFilter(array(), array(new AddressFilter(5, array(55))));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$previous = new Breadcrumb('label', 'route', array('x' => 'y'));
		$helper->shouldReceive('getBreadcrumbFromFilter')->once()->with($filter, $previous)->andReturn('success');
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\BrokerListAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($previous);
		$builder = new BrokerListAndCountyAndRegion($previousBuilder, $helper);

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}

}
