<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Broker\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\BrokerFilter;
use Dalten\WebBundle\Entity\Broker;
use Dalten\WebBundle\Breadcrumbs\Broker\Builder\BrokerListAndCounty;
use Mockery as m;

class BrokerListAndCountyTest extends \PHPUnit_Framework_TestCase
{
	public function testBuilderCannotCreateBreadcrumbFromBrokerModel()
	{
		$Broker = new Broker();

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumb')->never();
		$builder = new BrokerListAndCounty($helper, 'route', array());

		$this->assertNull($builder->getBreadcrumbFromBroker($Broker));
	}

	public function testBuilderCorrectlyCallsHelperToCreateBreadcrumbFromFilter()
	{
		$routeName = 'test';

		$filter = new BrokerFilter(array(), array(new AddressFilter(7, array())));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->with($filter, $routeName, array())->andReturn('success');
		$builder = new BrokerListAndCounty($helper, $routeName, array());

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}

	public function testBuilderPassesSpecifiedParamsIntoRouteParams()
	{
		$routeName = 'test';
		$params = array('test' => 'ok');

		$filter = new BrokerFilter(array(), array(new AddressFilter(7, array())));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->with($filter, $routeName, $params)->andReturn('success');
		$builder = new BrokerListAndCounty($helper, $routeName, $params);

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}

}
