<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Common\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper;

/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 30. 10. 2014
 * Time: 14:43
 */
class CountyHelperTest extends \PHPUnit_Framework_TestCase
{
	private $_countyIdToSlugMap = array(7 => 'bagr', 8 => 'bagrik');
	private $_countyIdToLabelMap = array(7 => 'Bagr', 8 => 'bagrik');

	public function testBuilderReturnsNullIfCountyCannotBeMapped()
	{
		$countyCode = 5;
		$builder = new CountyHelper($this->_countyIdToSlugMap, $this->_countyIdToLabelMap);

		$this->assertNull($builder->getBreadcrumb($countyCode, 'test', array()));
	}

	public function testBuilderCreatesBreadcrumbWithCorrectLabelAndSlug()
	{
		$countyCode = 7;
		$routeName = 'test';
		$builder = new CountyHelper($this->_countyIdToSlugMap, $this->_countyIdToLabelMap);

		$crumb = $builder->getBreadcrumb($countyCode, $routeName, array());
		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\Breadcrumb', $crumb);
		$this->assertSame(array('county' => 'bagr'), $crumb->getRouteParams());
		$this->assertSame($routeName, $crumb->getRouteName());
		$this->assertSame('Bagr', $crumb->getLabel());
	}

	public function testBuilderAddsCountySlugToExistingRouteParams()
	{
		$countyCode = 7;
		$routeName = 'test';
		$builder = new CountyHelper($this->_countyIdToSlugMap, $this->_countyIdToLabelMap);

		$crumb = $builder->getBreadcrumb($countyCode, $routeName, array('x' => 'y'));
		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\Breadcrumb', $crumb);
		$this->assertSame(array('x' => 'y', 'county' => 'bagr'), $crumb->getRouteParams());
	}

	public function testBuilderCanCreateBreadcrumbFromFilter()
	{
		$countyCode = 7;
		$routeName = 'test';
		$filter = new ListingFilter(array(), array(new AddressFilter($countyCode, array())));
		$builder = new CountyHelper($this->_countyIdToSlugMap, $this->_countyIdToLabelMap);

		$crumb = $builder->getBreadcrumbFromFilter($filter, $routeName);
		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\Breadcrumb', $crumb);
		$this->assertSame(array('county' => 'bagr'), $crumb->getRouteParams());
		$this->assertSame($routeName, $crumb->getRouteName());
		$this->assertSame('Bagr', $crumb->getLabel());
	}

	public function testBuilderUsesFirstFoundCountyCodeFromFilter()
	{
		$countyCode = 7;
		$routeName = 'test';
		$filter = new ListingFilter(
			array(),
			array(new AddressFilter($countyCode, array()), new AddressFilter(8, array()))
		);
		$builder = new CountyHelper($this->_countyIdToSlugMap, $this->_countyIdToLabelMap);

		$crumb = $builder->getBreadcrumbFromFilter($filter, $routeName);
		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\Breadcrumb', $crumb);
		$this->assertSame(array('county' => 'bagr'), $crumb->getRouteParams());
		$this->assertSame('Bagr', $crumb->getLabel());
	}
}
