<?php
namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Company\Builder\OfficeListAndCountyAndRegion;
use Mockery as m;

class OfficeListAndCountyAndRegionTest extends \PHPUnit_Framework_TestCase
{

	public function testBuilderCannotCreateBreadcrumbFromCompanyModel()
	{
		$company = new Company();

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$helper->shouldReceive('getBreadcrumb')->never();
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\OfficeListAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromCompany')->never();
		$builder = new OfficeListAndCountyAndRegion($previousBuilder, $helper);

		$this->assertNull($builder->getBreadcrumbFromCompany($company));
	}

	public function testBuilderCannotCreateBreadcrumbIfCountyBreadcrumbIsNotSet()
	{
		$filter = new CompanyFilter(array(), array(new AddressFilter(5, array(55))));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->never();
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\OfficeListAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn(null);
		$builder = new OfficeListAndCountyAndRegion($previousBuilder, $helper);

		$this->assertNull($builder->getBreadcrumbFromFilter($filter));
	}

	public function testBuilderPassesCorrectParametersToHelperAndReturnsResult()
	{
		$filter = new CompanyFilter(array(), array(new AddressFilter(5, array(55))));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$previous = new Breadcrumb('label', 'route', array('x' => 'y'));
		$helper->shouldReceive('getBreadcrumbFromFilter')->once()->with($filter, $previous)->andReturn('success');
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\OfficeListAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($previous);
		$builder = new OfficeListAndCountyAndRegion($previousBuilder, $helper);

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}

}
