<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 13.2.14
 * Time: 15:31
 */

namespace Dalten\WebBundle\Test\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Listing\Builder\Composite;
use Mockery as m;

class CompositeTest extends \PHPUnit_Framework_TestCase
{
	public function testCompositeBuilderReturnsFirstGeneratedBreadcrumbFromFilterFromChildBuilders()
	{
		$crumb = new Breadcrumb('test', 'testik', array('x' => 'y'));

		$filter = new ListingFilter(array());
		$firstBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$firstBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn(null);
		$secondBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$secondBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($crumb);
		$thirdBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$thirdBuilder->shouldReceive('getBreadcrumbFromFilter')->never();

		$generator = new Composite(array($firstBuilder, $secondBuilder, $thirdBuilder));
		$this->assertSame($crumb, $generator->getBreadcrumbFromFilter($filter));
	}

	public function testCompositeGeneratorReturnsEmptyStringIfNoInnerGeneratorsCreateBreadcrumbFromFilter()
	{
		$filter = new ListingFilter(array());
		$firstBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$firstBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn(null);

		$generator = new Composite(array($firstBuilder));
		$this->assertNull($generator->getBreadcrumbFromFilter($filter));
	}

	public function testCompositeBuilderReturnsFirstGeneratedBreadcrumbFromListingFromChildBuilders()
	{
		$crumb = new Breadcrumb('test', 'testik', array('x' => 'y'));
		$listing = new Listing();

		$firstBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$firstBuilder->shouldReceive('getBreadcrumbFromListing')->with($listing)->andReturn(null);
		$secondBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$secondBuilder->shouldReceive('getBreadcrumbFromListing')->with($listing)->andReturn($crumb);
		$thirdBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$thirdBuilder->shouldReceive('getBreadcrumbFromListing')->never();

		$generator = new Composite(array($firstBuilder, $secondBuilder, $thirdBuilder));
		$this->assertSame($crumb, $generator->getBreadcrumbFromListing($listing));
	}

	public function testCompositeGeneratorReturnsEmptyStringIfNoInnerGeneratorsCreateBreadcrumbFromListing()
	{
		$listing = new Listing();
		$firstBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$firstBuilder->shouldReceive('getBreadcrumbFromListing')->with($listing)->andReturn(null);

		$generator = new Composite(array($firstBuilder));
		$this->assertNull($generator->getBreadcrumbFromListing($listing));
	}
}
