<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 28.7.14
 * Time: 14:08
 */

namespace Dalten\WebBundle\Tests\Processor;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Processor\EmptyListingResultHandler;
use \Mockery as m;

class EmptyListingResultHandlerTest extends \PHPUnit_Framework_TestCase
{
	private $_linkLabels = array(
		'region' => 'region',
		'area' => 'area',
		'price' => 'price',
		'subtype' => 'subtype',
		'locality_text' => 'locality_text',
		'extended' => 'extended',
	);

	private $_routeName = 'test';

	public function testHandlerCanRemoveRegionConditions()
	{
		$filter = new ListingFilter(array(), array(new AddressFilter(1, array(5))));

		$seoRouteMatcher = m::mock('Dalten\WebBundle\SeoRoute\FragmentCollection');
		$seoRouteMatcher->shouldReceive('getRouteConfig')->andReturn(null)->once();
		$converter = m::mock('Dalten\WebBundle\Filter\Converter\ListingListInterface');
		$translator = m::mock('Symfony\Component\Translation\TranslatorInterface');
		$translator->shouldReceive('trans')->once()->with('region')->andReturn('trans');
		$test = $this;
		$converter->shouldReceive('getRouteParamsFromFilter')
			->with(
				m::on(
					function ($filter) use ($test) {
						/** @var ListingFilter $filter */
						$addressFilters = $filter->getAddressFilters();
						$test->assertCount(1, $addressFilters);
						/** @var AddressFilter $addressFilter */
						$addressFilter = current($addressFilters);
						$test->assertSame(array(), $addressFilter->region_codes);
						$test->assertSame(1, $addressFilter->county_code);

						return true;
					}
				)
			)->andReturn(array(111));

		$handler = new EmptyListingResultHandler($seoRouteMatcher, $converter, $translator, $this->_linkLabels);

		$routeConfigs = $handler->getAlternateFilterLinks($filter, $this->_routeName);

		$this->assertCount(1, $routeConfigs);
		$this->assertArrayHasKey('region', $routeConfigs);
		$this->assertArrayHasKey('name', $routeConfigs['region']);
		$this->assertArrayHasKey('label', $routeConfigs['region']);
		$this->assertArrayHasKey('parameters', $routeConfigs['region']);
		$this->assertSame($this->_routeName, $routeConfigs['region']['name']);
		$this->assertSame('trans', $routeConfigs['region']['label']);
		$this->assertSame(array(111), $routeConfigs['region']['parameters']);
	}

	/**
	 * @dataProvider propertiesToRemoveProvider
	 */
	public function testHandlerCanRemoveFilterProperties($expectedSlug, $filterData, $removedParams)
	{
		$filter = new ListingFilter($filterData);

		$seoRouteMatcher = m::mock('Dalten\WebBundle\SeoRoute\FragmentCollection');
		$seoRouteMatcher->shouldReceive('getRouteConfig')->andReturn(null)->once();
		$converter = m::mock('Dalten\WebBundle\Filter\Converter\ListingListInterface');
		$translator = m::mock('Symfony\Component\Translation\TranslatorInterface');
		$translator->shouldReceive('trans')->once()->with($this->_linkLabels[$expectedSlug])->andReturn('trans');
		$test = $this;
		$converter->shouldReceive('getRouteParamsFromFilter')
			->with(
				m::on(
					function ($filter) use ($test, $removedParams) {
						/** @var ListingFilter $filter */
						foreach ($removedParams as $removedParam) {
							$this->assertEmpty($filter->$removedParam);
						}

						return true;
					}
				)
			)->andReturn(array(111));

		$handler = new EmptyListingResultHandler($seoRouteMatcher, $converter, $translator, $this->_linkLabels);
		$routeConfigs = $handler->getAlternateFilterLinks($filter, $this->_routeName);

		$this->assertCount(1, $routeConfigs);
		$this->assertArrayHasKey($expectedSlug, $routeConfigs);
		$this->assertArrayHasKey('name', $routeConfigs[$expectedSlug]);
		$this->assertArrayHasKey('label', $routeConfigs[$expectedSlug]);
		$this->assertArrayHasKey('parameters', $routeConfigs[$expectedSlug]);
		$this->assertSame($this->_routeName, $routeConfigs[$expectedSlug]['name']);
		$this->assertSame('trans', $routeConfigs[$expectedSlug]['label']);
		$this->assertSame(array(111), $routeConfigs[$expectedSlug]['parameters']);
	}

	public function testHandlerCanCreateSeoRoutes()
	{
		$filter = new ListingFilter(array('main_area_min' => 10));

		$seoRouteMatcher = m::mock('Dalten\WebBundle\SeoRoute\FragmentCollection');
		$seoRouteMatcher->shouldReceive('getRouteConfig')
			->andReturn(array('name' => 'bagr', 'parameters' => array(111)))->once();
		$converter = m::mock('Dalten\WebBundle\Filter\Converter\ListingListInterface');
		$converter->shouldReceive('getRouteParamsFromFilter')->never();
		$translator = m::mock('Symfony\Component\Translation\TranslatorInterface');
		$translator->shouldReceive('trans')->once()->with($this->_linkLabels['area'])->andReturn('trans');

		$handler = new EmptyListingResultHandler($seoRouteMatcher, $converter, $translator, $this->_linkLabels);
		$routeConfigs = $handler->getAlternateFilterLinks($filter, $this->_routeName);

		$this->assertCount(1, $routeConfigs);
		$this->assertArrayHasKey('area', $routeConfigs);
		$this->assertArrayHasKey('name', $routeConfigs['area']);
		$this->assertArrayHasKey('label', $routeConfigs['area']);
		$this->assertArrayHasKey('parameters', $routeConfigs['area']);
		$this->assertSame('bagr', $routeConfigs['area']['name']);
		$this->assertSame('trans', $routeConfigs['area']['label']);
		$this->assertSame(array(111), $routeConfigs['area']['parameters']);
	}

	public function propertiesToRemoveProvider()
	{
		return array(
			'area' => array(
				'area',
				array('main_area_max' => 10, 'main_area_min' => 5),
				array('main_area_max', 'main_area_min')
			),
			'price' => array(
				'price',
				array('price_max' => 10, 'price_min' => 5),
				array('price_max', 'price_min')
			),
			'locality_text' => array(
				'locality_text',
				array('locality_text' => 'bagr'),
				array('locality_text')
			),
			'extended' => array(
				'extended',
				array(
					'building_type' => 7,
					'building_condition' => 5,
					'floor_min' => 1,
					'floor_max' => 5,
					'ownership' => 1
				),
				array('building_type', 'building_condition', 'ownership', 'floor_min', 'floor_max')
			),
			'subtype' => array(
				'subtype',
				array(
					'flat_kind' => 1,
					'object_kind_houses' => 1,
					'object_kind_cottages' => 1,
					'object_kind_smallobjects' => 1,
					'commercial_kind' => 1,
					'estate_kind' => 1,
					'hotel_kind' => 1,
					'office_kind => 1'
				),
				array(
					'flat_kind',
					'object_kind_houses',
					'object_kind_cottages',
					'object_kind_smallobjects',
					'commercial_kind',
					'estate_kind',
					'hotel_kind',
					'office_kind'
				)
			),
		);
	}
}

