<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 19.12.13
 * Time: 14:45
 */

namespace Dalten\WebBundle\Tests\Processor\TitleGenerator\ListingList;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Processor\TitleGenerator\ListingList\Address;


class AddressTest extends \PHPUnit_Framework_TestCase
{
	private $_counties = array(7 => 'bagr', 9 => 'kolobezka');
	private $_regions = array(7 => array(99 => 'motor'), 9 => array(5 => 'přední kolo', 7 => 'řidítka'));

	/** @var  \Symfony\Component\Translation\TranslatorInterface */
	private $_translator;

	protected function setUp()
	{
		$this->_translator = $this->getMockBuilder('Symfony\Component\Translation\TranslatorInterface')
			->getMock();
		$this->_translator->expects($this->any())->method('trans')->will($this->returnArgument(0));
	}

	public function testGeneratorGroupsAddsSelectedCountyNames()
	{
		$filter = new ListingFilter(array(), array(new AddressFilter(7, array()))
		);

		$this->assertEquals('bagr', $this->_getTitleForFilter($filter));
	}

	public function testGeneratorUsesRegionNamesInsteadOfCountyNamesIfTheyAreSpecified()
	{
		$filter = new ListingFilter(array(), array(new AddressFilter(7, array()), new AddressFilter(9, array(5, 7))));

		$this->assertEquals('bagr, přední kolo, řidítka', $this->_getTitleForFilter($filter));
	}

	public function testGeneratorReturnsAllCountiesTitleIfAllCountiesAndNoRegionsAreSetAndTitleIsSpecified()
	{
		$filter = new ListingFilter(array(), array(new AddressFilter(7, array()), new AddressFilter(9, array())));

		$generator = new Address(
			$this->_translator, $this->_counties, $this->_regions, 'ALL_REGIONS'
		);

		$this->assertEquals('ALL_REGIONS', $generator->createTitle($filter));
	}

	public function testGeneratorDoesNotReturnAllCountiesTitleIfAllCountiesAndAtLeastOneRegionIsSetAndTitleIsSpecified()
	{
		$filter = new ListingFilter(array(), array(new AddressFilter(7, array()), new AddressFilter(9, array(5))));

		$generator = new Address(
			$this->_translator, $this->_counties, $this->_regions, 'ALL_REGIONS'
		);

		$this->assertEquals('bagr, přední kolo', $generator->createTitle($filter));
	}

	private function _getTitleForFilter(ListingFilter $filter)
	{
		$generator = new Address(
			$this->_translator, $this->_counties, $this->_regions
		);

		return $generator->createTitle($filter);
	}

}
