<?php

namespace Dalten\WebBundle\Breadcrumbs\Broker\Builder;

use Dalten\WebBundle\Filter\BrokerFilter;
use Dalten\WebBundle\Entity\Broker;

/**
 * Rozhraní pro tvořiče drobečků.
 */
interface BuilderInterface
{
	/**
	 * Vytvoří drobka z vyplněného modelu.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param Broker $broker Model makléře.
	 *
	 * @return \Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface|null  Drobek nebo null.
	 */
	public function getBreadcrumbFromBroker(Broker $broker);

	/**
	 * Vytvoří drobka z vyplněného filtru makléřů.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param BrokerFilter $filter Filtr.
	 *
	 * @return \Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface|null  Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(BrokerFilter $filter);
}
