<?php

namespace Dalten\WebBundle\Breadcrumbs\Broker\Collection;

use Dalten\WebBundle\Filter\BrokerFilter;
use Dalten\WebBundle\Entity\Broker;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;
use Dalten\WebBundle\Breadcrumbs\Broker\Builder\BuilderInterface;

/**
 * Tvořič kolekcí drobečků.
 */
class Builder
{
	/**
	 * Pole tvořičů drobečků.
	 *
	 * @var BuilderInterface[]
	 */
	private $_builders;

	/**
	 * Nastavuje pole builderů drobečků.
	 *
	 * @param BuilderInterface[] $builders Tvořiče drobečků.
	 */
	public function __construct(array $builders = array())
	{
		$this->_builders = $builders;
	}

	/**
	 * Vytvoří pole drobečků z firmy.
	 *
	 * @param Broker $broker Model makléře.
	 *
	 * @return BreadcrumbInterface[] Drobky.
	 */
	public function getBreadcrumbsFromBroker(Broker $broker)
	{
		$crumbs = array();
		foreach ($this->_builders as $builder) {
			$crumbs[] = $builder->getBreadcrumbFromBroker($broker);
		}

		return array_filter($crumbs);
	}

	/**
	 * Vytvoří pole drobečků z filtru nabídek.
	 *
	 * @param BrokerFilter $filter Filtr firem.
	 *
	 * @return BreadcrumbInterface[] Drobky.
	 */
	public function getBreadcrumbsFromFilter(BrokerFilter $filter)
	{
		$crumbs = array();
		foreach ($this->_builders as $builder) {
			$crumbs[] = $builder->getBreadcrumbFromFilter($filter);
		}

		return array_filter($crumbs);
	}
}
