<?php

namespace Dalten\WebBundle\Breadcrumbs\Listing\Breadcrumb;

/**
 * Specifický drobeček pro rozmezí ceny.
 */
class PriceRangeBreadcrumb extends \Dalten\WebBundle\Breadcrumbs\Breadcrumb
{

	/**
	 * Minimální cena.
	 *
	 * @var float
	 */
	private $_minPrice;

	/**
	 * Maximální cena.
	 *
	 * @var float
	 */
	private $_maxPrice;

	/**
	 * Nastavuje parametry drobečku, které již poté nelze změnit.
	 *
	 * @param string $label       Název drobečku.
	 * @param string $routeName   Název routy na kterou drobeček vede.
	 * @param array  $routeParams Paramery routy.
	 * @param float  $minPrice    Minimální cena.
	 * @param float  $maxPrice    Maximální cena.
	 */
	public function __construct($label, $routeName, array $routeParams = array(), $minPrice, $maxPrice)
	{
		parent::__construct($label, $routeName, $routeParams);
		$this->_maxPrice = $maxPrice;
		$this->_minPrice = $minPrice;
	}

	/**
	 * Vrátí maximální cenu.
	 *
	 * @return float
	 */
	public function getMaxPrice()
	{
		return $this->_maxPrice;
	}

	/**
	 * Vrátí minimální cenu.
	 *
	 * @return float
	 */
	public function getMinPrice()
	{
		return $this->_minPrice;
	}


	/**
	 * Vrátí název typu drobku.
	 *
	 * @return string Název typu drobku.
	 */
	public function getName()
	{
		return 'PriceRange';
	}

}
