<?php

namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;

/**
 * Drobeček na typ nemovitosti.
 */
class Composite implements BuilderInterface
{
	/**
	 * Konfigurace.
	 *
	 * @var BuilderInterface[]
	 */
	private $_builders;

	/**
	 * Nastavuje vnitřní buildery drobků.
	 *
	 * @param BuilderInterface[] $builders Pole builderů, které budou vnořeny do tohoto.
	 */
	public function __construct(array $builders)
	{
		$this->_builders = $builders;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu nabídky.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param Listing $listing Model nabídky.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromListing(Listing $listing)
	{
		foreach ($this->_builders as $builder) {
			$breadcrumb = $builder->getBreadcrumbFromListing($listing);

			if ($breadcrumb) {
				return $breadcrumb;
			}
		}

		return null;
	}

	/**
	 * Vytvoří drobka z vyplněného filtru nabídek.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(ListingFilter $filter)
	{
		foreach ($this->_builders as $builder) {
			$breadcrumb = $builder->getBreadcrumbFromFilter($filter);

			if ($breadcrumb) {
				return $breadcrumb;
			}
		}

		return null;
	}
}
