<?php
namespace Dalten\WebBundle\DependencyInjection;

use Dalten\WebBundle\DependencyInjection\Feature\Breadcrumbs;
use Dalten\WebBundle\DependencyInjection\Feature\DefaultEmailConfig;
use Dalten\WebBundle\DependencyInjection\Feature\FeatureWithCompilerPassInterface;
use Dalten\WebBundle\DependencyInjection\Feature\ListingListSeoRoutes;
use Dalten\WebBundle\DependencyInjection\Feature\ListingListTitleGenerator;
use Dalten\WebBundle\DependencyInjection\Feature\PropertyDisplayProvider;
use Dalten\WebBundle\DependencyInjection\Feature\Localisation;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 13.04.2016
 * Time: 15:48
 */
class WebExtension extends Extension implements CompilerPassInterface
{
	/**
	 * @var FeatureWithCompilerPassInterface[]
	 */
	private $_compilerPasses = [];

	/**
	 * Loads a specific configuration.
	 *
	 * @param array            $configs   An array of configuration values
	 * @param ContainerBuilder $container A ContainerBuilder instance
	 *
	 * @throws \InvalidArgumentException When provided tag is not defined in this extension
	 */
	public function load(array $configs, ContainerBuilder $container)
	{
		$configuration = new Configuration();

		$config = $this->processConfiguration($configuration, $configs);

		$this->_initCommonFeatures($container);

		$activeAliases = ['localities'];

		if (!empty($config['listing_seo_routes']['enabled'])) {
			$activeAliases[] = 'listing_seo_routes';
			$feature = new ListingListSeoRoutes();
			$feature->load($config['listing_seo_routes'], $container);
			$this->_compilerPasses[] = $feature;
		}

		if (!empty($config['listing_list_title_generator']['enabled'])) {
			$activeAliases[] = 'listing_list_title_generator';
			(new ListingListTitleGenerator())->load($config['listing_list_title_generator'], $container);
		}

		if (!empty($config['property_display_provider']['enabled'])) {
			$activeAliases[] = 'property_display_provider';
			(new PropertyDisplayProvider())->load($config['property_display_provider'], $container);
		}

		if (!empty($config['default_email_config']['enabled'])) {
			$activeAliases[] = 'default_email_config';
			(new DefaultEmailConfig())->load($config['default_email_config'], $container);
		}

		if (!empty($config['default_email_config']['enabled'])) {
			$activeAliases[] = 'breadcrumbs';
			(new Breadcrumbs())->load($config['breadcrumbs'], $container);
		}

		if (!empty($config['localisation']['enabled'])) {
			$activeAliases[] = 'localisation';
			// tato feature musí být poslední, aby dostala úplný seznam aktivních features
			(new Localisation($activeAliases))->load($config['localisation'], $container);
		}
	}

	public function getAlias()
	{
		return 'dalten_web';
	}

	/**
	 * @param ContainerBuilder $container
	 */
	private function _initCommonFeatures(ContainerBuilder $container)
	{
		$loader = new YamlFileLoader(
			$container,
			new FileLocator(__DIR__ . '/../Resources/config')
		);
		$loader->load('localities.yml');
	}

	/**
	 * You can modify the container here before it is dumped to PHP code.
	 *
	 * @param ContainerBuilder $container
	 */
	public function process(ContainerBuilder $container)
	{
		foreach ($this->_compilerPasses as $pass) {
			$pass->executeCompilerPass($container);
		}
	}
}
