<?php
namespace Dalten\WebBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @property int $id
 * @property string $name
 * @property string $email
 * @property string $invoice_address_name
 * @property string $invoice_address_street
 * @property string $invoice_address_city
 * @property string $invoice_address_zip
 * @property string $invoice_address_state
 * @property string $invoice_address_ir
 * @property string $invoice_address_vat_in
 * @property string $phone
 * @property string $fax
 * @property string $self_promo
 * @property string $office_description
 * @property string $office_description_en
 * @property string $office_logo
 * @property string $office_web_url
 * @property integer $company_category
 * @property integer $region_code
 * @property integer $city_code
 * @property integer $county_code
 * @property string $slug
 * @property array $mortgage_broker_list
 * @property array $lawyer_list
 * @property string $franchise_name
 * @property string $deposit_account_number
 * @property boolean $receive_copy_from_contact_forms
 * @property integer $court_name
 * @property integer $court_section
 * @property integer $court_insert
 * @property string $headquarters_street
 * @property string $headquarters_city
 * @property string $headquarters_zip
 * @property string $company_gpx_x
 * @property string $company_gpx_y
 * @property string $seznam_retargeting_id
 * @property string $google_analytics_id
 * @property string $google_retargeting_id
 * @property string $seo_text
 * @property string $image_alt_text
 * 
 * @ORM\Table(name="firma")
 * @ORM\MappedSuperclass
 */
class Company implements EntityWithLegacyData
{
    use LegacyDataMethods;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nazev", type="string", length=100, nullable=true)
     */
    private $_nazev;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=100, nullable=true)
     */
    private $_email;

    /**
     * @var integer
     *
     * @ORM\Column(name="cenovy_program", type="integer", nullable=false)
     */
    private $_cenovy_program;

    /**
     * @var integer
     *
     * @ORM\Column(name="pocet_uzivatel_navic", type="integer", nullable=false)
     */
    private $_pocet_uzivatel_navic;

    /**
     * @var integer
     *
     * @ORM\Column(name="platebni_obdobi_od", type="integer", nullable=false)
     */
    private $_platebni_obdobi_od;

    /**
     * @var integer
     *
     * @ORM\Column(name="platebni_obdobi", type="integer", nullable=false)
     */
    private $_platebni_obdobi;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="registrace", type="date", nullable=false)
     */
    private $_registrace;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="registrace_do", type="date", nullable=false)
     */
    private $_registrace_do;

    /**
     * @var string
     *
     * @ORM\Column(name="fakt_jmeno", type="string", length=100, nullable=true)
     */
    private $_fakt_jmeno;

   /**
     * @var string
     *
     * @ORM\Column(name="fakt_ulice", type="string", length=100, nullable=true)
     */
    private $_fakt_ulice;

    /**
     * @var string
     *
     * @ORM\Column(name="fakt_mesto", type="string", length=100, nullable=true)
     */
    private $_fakt_mesto;

   /**
     * @var string
     *
     * @ORM\Column(name="fakt_psc", type="string", length=100, nullable=true)
     */
    private $_fakt_psc;

    /**
     * @var string
     *
     * @ORM\Column(name="fakt_stat", type="string", length=100, nullable=true)
     */
    private $_fakt_stat;

    /**
     * @var string
     *
     * @ORM\Column(name="fakt_ic", type="string", length=100, nullable=true)
     */
    private $_fakt_ic;

    /**
     * @var string
     *
     * @ORM\Column(name="fakt_dc", type="string", length=100, nullable=true)
     */
    private $_fakt_dc;

    /**
     * @var string
     *
     * @ORM\Column(name="www", type="string", length=100, nullable=true)
     */
    private $_www;

    /**
     * @var string
     *
     * @ORM\Column(name="telefon", type="string", length=100, nullable=true)
     */
    private $_telefon;

   /**
     * @var string
     *
     * @ORM\Column(name="fax", type="string", length=100, nullable=true)
     */
    private $_fax;

    /**
     * @var string
     *
     * @ORM\Column(name="photoid_ilist", type="string", length=100, nullable=true)
     */
    private $_photoid_ilist;

    /**
     * @var string
     *
     * @ORM\Column(name="bulletpoint", type="string", length=100, nullable=true)
     */
    private $_bulletpoint;

    /**
     * @var string
     *
     * @ORM\Column(name="closer", type="string", length=100, nullable=true)
     */
    private $_closer;

    /**
     * @var string
     *
     * @ORM\Column(name="officedescription", type="string", length=100, nullable=true)
     */
    private $_officedescription;

    /**
     * @var string
     *
     * @ORM\Column(name="officedescription_en", type="string", length=100, nullable=true)
     */
    private $_officedescription_en;

    /**
     * @var string
     *
     * @ORM\Column(name="officepicture", type="string", length=100, nullable=true)
     */
    private $_officepicture;

    /**
     * @var string
     *
     * @ORM\Column(name="poznamka", type="string", length=100, nullable=true)
     */
    private $_poznamka;

    /**
     * @var integer
     *
     * @ORM\Column(name="okres", type="integer", nullable=false)
     */
    private $_okres;

    /**
     * @var integer
     *
     * @ORM\Column(name="mesto", type="integer", nullable=false)
     */
    private $_mesto;

    /**
     * @var integer
     *
     * @ORM\Column(name="kraj", type="integer", nullable=false)
     */
    private $_kraj;

    /**
     * @var string
     *
     * @ORM\Column(name="link", type="string", length=100, nullable=true)
     */
    private $_link;

    /**
     * @var string
     *
     * @ORM\Column(name="hypotecni_makleri", type="string", length=100, nullable=true)
     */
    private $_hypotecni_makleri;

    /**
     * @var string
     *
     * @ORM\Column(name="advokati", type="string", length=100, nullable=true)
     */
    private $_advokati;

    /**
     * @var string
     *
     * @ORM\Column(name="fransiza_jmeno", type="string", length=100, nullable=true)
     */
    private $_fransiza_jmeno;

    /**
     * @var string
     *
     * @ORM\Column(name="depozitni_ucet", type="string", length=100, nullable=true)
     */
    private $_depozitni_ucet;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_gps_x", type="string", length=100, nullable=true)
     */
    private $_firma_gps_x;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_gps_y", type="string", length=100, nullable=true)
     */
    private $_firma_gps_y;

    /**
     * @var string
     *
     * @ORM\Column(name="suggest_fulltext", type="string", length=100, nullable=true)
     */
    private $_suggest_fulltext;

    /**
     * @var integer
     *
     * @ORM\Column(name="or_soud_nazev", type="integer", nullable=false)
     */
    private $_or_soud_nazev;

    /**
     * @var integer
     *
     * @ORM\Column(name="or_soud_oddil", type="integer", nullable=false)
     */
    private $_or_soud_oddil;

    /**
     * @var integer
     *
     * @ORM\Column(name="or_soud_vlozka", type="integer", nullable=false)
     */
    private $_or_soud_vlozka;

    /**
     * @var string
     *
     * @ORM\Column(name="or_sidlo_ulice", type="string", length=100, nullable=true)
     */
    private $_or_sidlo_ulice;

    /**
     * @var string
     *
     * @ORM\Column(name="or_sidlo_mesto", type="string", length=100, nullable=true)
     */
    private $_or_sidlo_mesto;

    /**
     * @var string
     *
     * @ORM\Column(name="or_sidlo_psc", type="string", length=100, nullable=true)
     */
    private $_or_sidlo_psc;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_seo_lokalita", type="string", length=100, nullable=true)
     */
    private $_firma_seo_lokalita;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_google_analytics", type="string", length=100, nullable=true)
     */
    private $_firma_google_analytics;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_seznam_retargeting_id", type="string", length=100, nullable=true)
     */
    private $_firma_seznam_retargeting_id;

    /**
     * @var boolean
     *
     * @ORM\Column(name="posilat_kopie_dotazu_na_mail_rk", type="integer", nullable=false)
     */
    private $_posilat_kopie_dotazu_na_mail_rk;

    /**
     * @var string
     *
     * @ORM\Column(name="suggest_detail", type="string", length=100, nullable=true)
     */
    private $_suggest_detail;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_google_retargeting_id", type="string", length=100, nullable=true)
     */
    private $_firma_google_retargeting_id;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_seo_text", type="string", length=100, nullable=true)
     */
    private $_firma_seo_text;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_alt_text", type="string", length=100, nullable=true)
     */
    private $_firma_alt_text;

    private static $_map = array(
        'id' => '_id',
        'name' => '_nazev',
        'email' => '_email',
        'invoice_address_name' => '_fakt_jmeno',
        'invoice_address_street' => '_fakt_ulice',
        'invoice_address_city' => '_fakt_mesto',
        'invoice_address_zip' => '_fakt_psc',
        'invoice_address_state' => '_fakt_stat',
        'invoice_address_ir' => '_fakt_ic',
        'invoice_address_vat_in' => '_fakt_dc',
        'phone' => '_telefon',
        'fax' => '_fax',
        'self_promo' => '_bulletpoint',
        'office_description' => '_officedescription',
        'office_description_en' => '_officedescription_en',
        'office_logo' => '_officepicture',
        'office_web_url' => '_www',
        'region_code' => '_okres',
        'city_code' => '_mesto',
        'county_code' => '_kraj',
        'slug' => '_link',
        'mortgage_broker_list' => '_hypotecni_makleri',
        'lawyer_list' => '_advokati',
        'franchise_name' => '_fransiza_jmeno',
        'deposit_account_number' => '_depozitni_ucet',
        'receive_copy_from_contact_forms' => '_posilat_kopie_dotazu_na_mail_rk',
        'court_name' => '_or_soud_nazev',
        'court_section' => '_or_soud_oddil',
        'court_insert' => '_or_soud_vlozka',
        'headquarters_street' => '_or_sidlo_ulice',
        'headquarters_city' => '_or_sidlo_mesto',
        'headquarters_zip' => '_or_sidlo_psc',
        'company_gpx_x' => '_firma_gps_x',
        'company_gpx_y' => '_firma_gps_y',
        'seznam_retargeting_id' => '_firma_seznam_retargeting_id',
        'google_analytics_id' => '_firma_google_analytics',
        'google_retargeting_id' => '_firma_google_retargeting_id',
        'seo_text' => '_firma_seo_text',
        'image_alt_text' => '_firma_alt_text',
    );
}
