<?php
namespace Dalten\WebBundle\Processor;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 02.02.2016
 * Time: 15:48
 */
class GpsCoordinateConverter
{
	/**
	 * Převádí předané souřadnice ze stupňů na float.
	 *
	 * Pokud předané souřadnice nejsou ve správném tvaru, vrací null.
	 *
	 * @param string $value Hodnota k filtrování.
	 *
	 * @return string Filtrovaná hodnota nebo null.
	 */
	public function stringCoordinateToDecimal($value)
	{
		$value = \trim($value);
		$parts = array();
		$pattern = '~^(?<degree>[0-9]{1,3}).(?<minute>[0-9]{1,2})\'(?<second>[0-9]+)';
		$pattern .= '(?<milisecond>\.[0-9]+)?"(?<letter>[NSEW])$~u';
		if (\preg_match($pattern, $value, $parts)) {
			if (self::_isValidCoordinate($parts) === false) {
				return null;
			}
			if (isset($parts['milisecond']) && $parts['milisecond']) {
				$parts['second'] += floatVal('0' . $parts['milisecond']);
			}
			$return = (int) $parts['degree'];
			$return += $parts['minute'] / 60;
			$return += $parts['second'] / 3600;
			if ($parts['letter'] === 'S' || $parts['letter'] === 'W') {
				$return *= -1;
			}

			return $return;
		}

		return null;
	}

	/**
	 * Pomocná metoda, která zlehka validuje jednotlivé složky souřadnice.
	 *
	 * @param array $parts Asociativní pole složek souřadnice.
	 *
	 * @return bool True pokud je takováto souřadnice možná, jinak false.
	 */
	private function _isValidCoordinate(array $parts)
	{
		$valid = true;
		$valid = $valid && ($parts['degree'] >= 0 && $parts['degree'] <= 180);
		$valid = $valid && ($parts['minute'] >= 0 && $parts['minute'] <= 60);
		$valid = $valid && ($parts['second'] >= 0 && $parts['second'] <= 60);

		return $valid;
	}
}
