<?php
namespace Dalten\WebBundle\SeoRoute\Matcher\ListingFilter;

use Dalten\WebBundle\Filter\ListingFilter;

/**
 * Rozhraní pro matchery fragmentů filtru.
 *
 * Každý matcher má na starosti jednu logickou část filtru a na základě jí je schopen převést filtr na část parametrů
 * routy. Pomocí těchto informací poté třída FragmentCollection dokáže získat parametry routy a seznam částí
 * filtru, které byly ke generování použity.
 */
interface FragmentMatcherInterface
{

	/**
	 * Vrací pole parametrů pro routu, obsahující matchnutý fragment.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return array Pole parametrů nalezené routy a nebo prázdné pole.
	 */
	public function getRouteParamsForFilter(ListingFilter $filter);

	/**
	 * Vrátí pole názvů vlastností filtru, které byly zpracovány tímto fragmentem pro daný filtr.
	 *
	 * Vrací prázdné pole, pokud daný filtr není pokryt.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return array Pole názvů vlastností filtru, byly zpracovány tímto fragmentem pro daný filtr.
	 */
	public function getMatchedFilterParamsForFilter(ListingFilter $filter);
}

