<?php
namespace Dalten\WebBundle\Twig\Extensions\Extension;

use Dalten\WebBundle\Processor\GpsCoordinateConverter;

/**
 * Umožňuje převést GPS souřadnice ze stringu na float.
 */
class GpsHelper extends \Twig_Extension
{
	/** @var  GpsCoordinateConverter */
	private $_coordinateConverter;

	/**
	 * GpsHelper constructor.
	 *
	 * @param GpsCoordinateConverter $coordinateConverter
	 */
	public function __construct(GpsCoordinateConverter $coordinateConverter)
	{
		$this->_coordinateConverter = $coordinateConverter;
	}

	/**
	 * Převádí pomocí GPS souřadnice z textu na float.
	 *
	 * @param string $text GPS souřadnice jako text.
	 *
	 * @return string Float GPS souřadnice.
	 */
	public function gpsToDecimal($text)
	{
		return $this->_coordinateConverter->stringCoordinateToDecimal($text);
	}

	/**
	 * @inheritdoc
	 */
	public function getFilters()
	{
		return array(
			'gps_to_decimal' => new \Twig_SimpleFilter('gps_to_decimal', [$this, 'gpsToDecimal'])
		);
	}

	/**
	 * Returns the name of the extension.
	 *
	 * @return string The extension name
	 */
	public function getName()
	{
		return 'gps_helper';
	}
}
