<?php
namespace Dalten\WebBundle\Twig\Extensions\Extension;

use Dalten\WebBundle\Entity\Listing;

/**
 * Twig extension na generování adresy nemovitostí pro mapu.
 */
class ListingMapAddress extends \Twig_Extension
{
	/**
	 * @inheritdoc
	 */
	public function getFunctions()
	{
		return array(
			'generateMapAddress' => new \Twig_SimpleFunction(
					'generateMapAddress', array($this, 'generateMapAddress')
			),
		);
	}

	/**
	 * Metoda na adresy pro mapu.
	 *
	 * @param Listing $listing
	 *
	 * @return string
	 */
	public function generateMapAddress(Listing $listing)
	{
		$return = array();
		if ($listing->listing_locality_street && $listing->listing_locality_inaccuracy_level != 0) {
			$street = $listing->listing_locality_street;
			if ($listing->listing_locality_cp) {
				$street .= ' ' . $listing->listing_locality_cp;
			}

			$return[] = $street . ',';
		}

		if ($listing->listing_locality_municipality_part) {
			$muniPart = '';
			if ($listing->listing_locality_country_code === 'CZ' && $listing->listing_locality_prague_district) {
				$muniPart = $listing->listing_locality_prague_district . ' - ';
			}
			$muniPart .= $listing->listing_locality_municipality_part;

			$return[] = $muniPart . ',';
		}

		if ($listing->listing_locality_municipality) {
			$return[] = $listing->listing_locality_municipality . ',';
		}

		if ($listing->listing_locality_region) {
			$return[] = $listing->listing_locality_region . ',';
		}

		if ($listing->listing_locality_county
			&& $listing->listing_locality_region != $listing->listing_locality_county) {
			$return[] = $listing->listing_locality_county . ',';
		}

		return implode(' ', array_unique($return));
	}

	/**
	 * Returns the name of the extension.
	 *
	 * @return string The extension name.
	 */
	public function getName()
	{
		return 'generateListingMapAddress';
	}

}
