<?php
namespace Dalten\WebBundle;

use Dalten\WebBundle\DependencyInjection\WebExtension;
use Dalten\WebBundle\Doctrine\Type\DateType;
use Doctrine\DBAL\Platforms\AbstractPlatform;
use Doctrine\DBAL\Types\Type;
use Symfony\Component\HttpKernel\Bundle\Bundle;

/**
 * WebBundle.
 */
class WebBundle extends Bundle
{
	public function __construct()
    {
    	if (!Type::hasType('dalten_date')) {
		    Type::addType('dalten_date', 'Dalten\WebBundle\Doctrine\Type\DateType');
	    }
    	if (!Type::hasType('multi_option')) {
		    Type::addType('multi_option', 'Dalten\WebBundle\Doctrine\Type\MultiOptionType');
	    }
    }

    public function boot()
    {
	    /** @var AbstractPlatform $platform */
	    $platform = $this->container->get('doctrine')->getConnection()->getDatabasePlatform();
	    $platform->registerDoctrineTypeMapping('dalten_date', 'dalten_date');
	    $platform->registerDoctrineTypeMapping('multi_option', 'multi_option');
    }

	public function getContainerExtension()
	{
		return new WebExtension();
	}

}
