<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 10.12.13
 * Time: 13:35
 */

namespace Dalten\WebBundle\Test\SeoRoute\Matcher\ListingFilter;


use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher;

class BasicFragmentMatcherTest extends \PHPUnit_Framework_TestCase
{
	public function testMatcherTriesToFindCorrespondingSlugForFilter()
	{
		$config = array(
			'bagr' => array('advert_type' => array(1)),
			'rypadlo' => array('advert_type' => array(2)),
		);
		$filter = new ListingFilter(array('advert_type' => 1, 'listing_type' => 4));
		$matcher = new BasicFragmentMatcher('advert_type_slug', $config);

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(1, $result);
		$this->assertArrayHasKey('advert_type_slug', $result);
		$this->assertEquals('bagr', $result['advert_type_slug']);
	}

	public function testMatcherOrdersExpectedAndFilterArrayFields()
	{
		$config = array(
			'bagr' => array('advert_type' => array(1, 2))
		);
		$filter = new ListingFilter(array('advert_type' => array(2, 1)));
		$matcher = new BasicFragmentMatcher('advert_type_slug', $config);

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(1, $result);
		$this->assertArrayHasKey('advert_type_slug', $result);
		$this->assertEquals('bagr', $result['advert_type_slug']);
	}

	public function testMatcherReturnsEmptyArrayIfNoMatchIsFound()
	{
		$config = array(
			'bagr' => array('advert_type' => array(1)),
			'rypadlo' => array('advert_type' => array(2)),
		);
		$filter = new ListingFilter(array('listing_type' => 4));
		$matcher = new BasicFragmentMatcher('advert_type_slug', $config);

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(0, $result);
	}

	public function testMatcherReturnsParamNamesItHadMatched()
	{
		$config = array(
			'bagr' => array('advert_type' => array(1)),
			'rypadlo' => array('advert_type' => array(2)),
		);
		$filter = new ListingFilter(array('listing_type' => 4, 'advert_type' => 1));
		$matcher = new BasicFragmentMatcher('advert_type_slug', $config);

		$this->assertSame(array('advert_type'), $matcher->getMatchedFilterParamsForFilter($filter));
	}

	public function testMatcherReturnsNoParamNamesIfNoMatchWasFound()
	{
		$config = array(
			'bagr' => array('advert_type' => array(1)),
			'rypadlo' => array('advert_type' => array(2)),
		);
		$filter = new ListingFilter(array('listing_type' => 4));
		$matcher = new BasicFragmentMatcher('advert_type_slug', $config);

		$this->assertSame(array(), $matcher->getMatchedFilterParamsForFilter($filter));
	}
}
