<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 11.12.13
 * Time: 16:03
 */

namespace Dalten\WebBundle\Test\SeoRoute\Matcher\ListingFilter;


use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\PriceFragmentMatcher;

class PriceFragmentMatcherTest extends \PHPUnit_Framework_TestCase
{

	public function testMatcherTriesToFindMapPriceValueToCorrespondingRouteParamNames()
	{
		$filter = new ListingFilter(array('price_min' => 5, 'price_max' => 10));
		$matcher = new PriceFragmentMatcher('price_from_test', 'price_to_test');

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(2, $result);
		$this->assertArrayHasKey('price_from_test', $result);
		$this->assertEquals(5, $result['price_from_test']);
		$this->assertArrayHasKey('price_to_test', $result);
		$this->assertEquals(10, $result['price_to_test']);
	}

	public function testMatcherReturnsEmptyArrayIfNoMatchIsFound()
	{
		$filter = new ListingFilter(array('price_min' => 0, 'price_max' => 0));
		$matcher = new PriceFragmentMatcher('price_from_test', 'price_to_test');

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(0, $result);
	}

	public function testMatcherReturnsEmptyMaxPricePropertyIfOnlyMinPriceIsSet()
	{
		$filter = new ListingFilter(array('price_min' => 5, 'price_max' => 0));
		$matcher = new PriceFragmentMatcher('price_from_test', 'price_to_test');

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(1, $result);
		$this->assertArrayHasKey('price_from_test', $result);
		$this->assertEquals(5, $result['price_from_test']);
	}

	public function testMatcherReturnsEmptyMinPricePropertyIfOnlyMaxPriceIsSet()
	{
		$filter = new ListingFilter(array('price_min' => 0, 'price_max' => 10));
		$matcher = new PriceFragmentMatcher('price_from_test', 'price_to_test');

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(1, $result);
		$this->assertArrayHasKey('price_to_test', $result);
		$this->assertEquals(10, $result['price_to_test']);
	}

	public function testMatcherReturnsParamNamesItHadMatched()
	{
		$partialFilter = new ListingFilter(array('price_min' => 5, 'price_max' => 0));
		$fullFilter = new ListingFilter(array('price_min' => 5, 'price_max' => 10));
		$matcher = new PriceFragmentMatcher('price_from_test', 'price_to_test');

		$this->assertSame(
			array('price_min', 'price_max'), $matcher->getMatchedFilterParamsForFilter($fullFilter)
		);
		$this->assertSame(array('price_min'), $matcher->getMatchedFilterParamsForFilter($partialFilter));
	}

	public function testMatcherReturnsNoParamNamesIfNoMatchWasFound()
	{
		$filter = new ListingFilter(array());
		$matcher = new PriceFragmentMatcher('price_from_test', 'price_to_test');


		$this->assertSame(array(), $matcher->getMatchedFilterParamsForFilter($filter));
	}
}
