<?php
namespace Dalten\Tests\Util;

use Dalten\Util\Base64\Base64;

/**
 * Created by JetBrains PhpStorm.
 * User: rbas
 * Date: 12/20/12
 * Time: 11:15 AM
 * To change this template use File | Settings | File Templates.
 */
class Base64Test extends \PHPUnit_Framework_TestCase
{
	/**
	 * JPG obrazek zakodovany do base64
	 *
	 * @var string
	 */
	private $_jpgImage = '/9j/4AAQSkZJRgABAQEASABIAAD//gATQ3JlYXRlZCB3aXRoIEdJTVD/2wBDAAQDAwMDAgQDAwMEBAQFBgoGBgUFBgwICQcKDgwPDg4MDQ0PERYTDxAVEQ0NExoTFRcYGRkZDxIbHRsYHRYYGRj/2wBDAQQEBAYFBgsGBgsYEA0QGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBgYGBj/wgARCAAKAAoDAREAAhEBAxEB/8QAFgABAQEAAAAAAAAAAAAAAAAAAAYH/8QAFAEBAAAAAAAAAAAAAAAAAAAAAP/aAAwDAQACEAMQAAAB1cqAD//EABgQAAIDAAAAAAAAAAAAAAAAAAEEAgUQ/9oACAEBAAEFAmrKC53/xAAUEQEAAAAAAAAAAAAAAAAAAAAg/9oACAEDAQE/AR//xAAUEQEAAAAAAAAAAAAAAAAAAAAg/9oACAECAQE/AR//xAAfEAACAAUFAAAAAAAAAAAAAAABAgMEETJBBRMgQpL/2gAIAQEABj8CnITQ9ULizZlC/QWELT1muOH/xAAZEAADAAMAAAAAAAAAAAAAAAABETEgIVH/2gAIAQEAAT8hqFdTIHh7ddow/9oADAMBAAIAAwAAABAAD//EABQRAQAAAAAAAAAAAAAAAAAAACD/2gAIAQMBAT8QH//EABQRAQAAAAAAAAAAAAAAAAAAACD/2gAIAQIBAT8QH//EABcQAQEBAQAAAAAAAAAAAAAAABEBEEH/2gAIAQEAAT8QUoYleknwgAiJv//Z';

	/**
	 * PNG obrazek zakodovany do base64
	 *
	 * @var string
	 */
	private $_pngImage = 'iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAIAAAACUFjqAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3AEbDDY4u1RfVQAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAAAAoSURBVBjTY/z//z8DbsDEgBdApRkZGZFF4VxGWhrOgimEoo4aduMCAEJWCRo2jo41AAAAAElFTkSuQmCCr';

	/**
	 * PNG obrazek zakodovany do base64
	 *
	 * @var string
	 */
	private $_pdf = 'JVBERi0xLjQKJcOkw7zDtsOfCjIgMCBvYmoKPDwvTGVuZ3RoIDMgMCBSL0ZpbHRlci9GbGF0ZURlY29kZT4+CnN0cmVhbQp4nDPQM1Qo5ypUMABCM0MjBXNLI4WiVK5wLYU8qKiBQlE6l1MIl6mZnoWCuZEJUENIioK+m6ECUHlImo2BIQTahWRxuYZwBXIFKgAA/2sR+AplbmRzdHJlYW0KZW5kb2JqCgozIDAgb2JqCjgwCmVuZG9iagoKNSAwIG9iago8PC9MZW5ndGggNiAwIFIvRmlsdGVyL0ZsYXRlRGVjb2RlL0xlbmd0aDEgNjI0OD4+CnN0cmVhbQp4nOVXa2wbV3Y+d4bkUNaDlGPJ8k4SXu5YfpQSKUvxM0pMSyRFWXZEPeiQcmxzRI5EOpLIkCN5nU1gbYvEBr1u3H0k68aAUxQosm0AD+1sobRurAC76BZokC3QP9uNGxXdHwVqxa4bL7a7a6nnXo5kyesk6Lb/eknO/c53Hvfcc+9w7uj5SQ2qYBpE8CfH1dw6QgDb3wOQtckpnS52+CniOQChfiQ3Or6l7WefAoi/BJCso2MnR15q/qQToBJdBGdaU1M/rrrkAah2IrEjjUR44aSEchjljelx/WvPw00bymMo28eySbUJ7DhgtY6ybVz9Wu4V28sWlF9CmU6o45rzWv1XUL6I5jtz2YKego2LAHX/yPS5vJa7O/SGHeXPcHwWgwBPH2cExMbl/+fNeg7qIGx9ChyQ49dVTXwHNrB+8ebq68KBxV/9X2ZhL3ffgz+Dd+Ec/BSOmIoQRCADk8isbB/APyDLWgSG4M+h+Dlh34EZ1JftEvAaXPgcuwi8AVfhb1eNEoFx+Drm8gP4KdkGf4dbJQt3iB2+AT/CqHeQO/iwUEINXkY4HFnB/gzeFM7CfuHnKFxgGsEnOOGHcJEcxcg6zvPc8ozbfyvoaXgZrwOQhinEvFmf+s0/QcXif+KsXob98PuwD8ZWeFwjl8Q1uH6DcAlr+gHnfEtKKSweF/5SEO59G4U/glH8qQTnLpwT90HAWkveBfAH47Ho4EB/X6T3mYMHevZ3h7tCwUBnxz7/3qefan9yz+5dO3ds39bi8zY3bdm8qXGj8lW3q2FdrdNRU125psIu2awWUSDQFFRCCWpsShiWTUo43MxkRUVCXUEkDIpUaLWNQRPcjK629KPlyAOW/rKlf9mSOGk7tDc30aBCjQ8DCp0hQ30xxOcCSpwa8xwf5NiyiQvVKLjd6EGDDekANUiCBo3QVLoYTAQwXqlyTafSqa1pboLSmkqElYiMLUquRLY8TTgQtgT3lASwV7NhDbExqKaMSF8sGJDd7nhzU7dRowS4Cjp5SMPWaUg8JM2w1OEsLTXNFr8544ThhKcqpaTU52KGqKJvUQwWi6eNWo+xVQkYW1/8eQPOXDOalEDQ8LCoPf3L4/TcH5IY1kanQot3AaejzN9czagmY2t03gUGQ1jeYjGk0FAxUVRnFqeHFepUiqWqqmIuiBWGSAy9Zhb/6qxshL4ZN5yJNNljTjbU32M80nc4ZgiNIZpWkcHvXsW9S3bXxpdsIp+nBiwElgNr6naziZ+d8cMwCsZ0X6wsUxiWr4Df54kbQoJpZpc0dVGmmV7SLLsnFFzNnoFY0bA0dqeUINb4rGpMD+N+Os6WQnEaNb+Q3UpxbS3d7YtzW4pZdacy1LBuwrKg10oH3CnMpejkQs0vyt28jANsql1LdysYhsUJKsGE+Z1KN2AA2txkhD3lpR+MGf4AAr9qrlGw1OJDDzWBS5QJ8OUzfErOWKd0LK8nSyuYGYhxF9PNWNdpQCJpehm+YICNTIPFRKCcAoul9MXeg7bFudITVL7aBk9APMCM6ztxX20KFmOpEcOVkFN4p43QmOw2/HFc4LgS0+Jso2GFts7hcG4+oiF0DsZ6BpSevqHYLjORsoKFszQGHwijxORyGNxyhr3RTmOCLMbR0IkEDSFQOtrxakiNdvw5seCcZVu1o53GiAxL1piGsZUGtYBpx+RVQa1sO3WGl6LZmIhxOsOyO+4ut+YmAdXUHBg97Kyo4SWV2Ij/BMgJGIZTrJYNbM/TmKIpcSVNDX8kxubGysOrbBaD19xcq8FV0opiYZnAjeolgRXTCHnklcU1uri8LIYfUHcvqWnRrvQMFFlwxQwImHm3AWwL+3fVyvzuZ/ezElLxJsY7mt/PxZLfz+7lNLtti0p3qqgMxNq5Nf6DvCy/yMZaCz2kZ7CjuQn/zDpKCjnTV/KTMwNDsffwzEbPDMauCEToTHTESxtRF3uP4rOCswJjGckEygQWqR8FO7eX3/MDTHOthRNcTs4Q4Jx9iSOQnBHKnHOJE5CzlDk/51jDVWpIY43x/ztIU2x9Xoqni4k42+NQjxXBLzGI8jRWR3m6RARblbFG0TqMSqWD8XsZv7fM2xgv4c4g9aS56cWiM6jcbWjmj24I4CVljeIJWAJviYCv/Ypksc+3lmzWj9uviAJCKImMtjL6imSr+E37FcL4tlp3baO71h0Q6MJG8r2FtDX6q78IWD4EdvLcDGBh568N5Fm/8w+kb0tCr+OYQ+iFYyCsnVn8t6sV1eHamcU5/wUE1VtqasNPVvVUHa4Sn6zsqTxcKcoVJCXp0nck0S9FJMEiPSEJKYFIkr2mptphwycx6a/uskvr7HapRpKc5LLtuu0jm2izVWftxGmn9ha76LATu132ywlZeEsmIFPEEXlWnpNtTzllQxaccgsSCfkn8m3ZBghz8nnkZ5GQ5JnF2avxI2HeH4yW++27ee9/xLMt7ABnV6KOQJ2zjtaJ9jrGP7q2LlxXH9mAj0qnWBdxQI1kESsfqbORiOiAvfOte9vWrt89v7517zzxeY4eeWG+tdWD7cgLeRTyzg+PHjnyQmur70jb2t21baedHo/zh87T9ln77LYWcqTc0BywqyCbt7vrpAqyvs69fSeRanlfiySJkW8MkwOTC5+R2MjCqUMLC19PLZw6cZZsIz8il+Tm5vULn977dH1z8wby3dMLdzYgsAp8Q7A3BuJ47uXkL+PHHO13wVU+u/547N1/WXlk4yvLDraCSaCf5F4IwrPLJg++ewjCTQjgyw3uC2gidtNCgK+YMQRw4hkOz7OWSttu3I1M+yg5tBzn6HJMgpZHTSzgrp0wsQgynqWJmaATzpvYiu9Db5nYhu8A75hYghfhr01sh3Vku4kroIZ0m7gSc3h2+a3KSwomroZT5E9MXAMegbKMLRXsbCr0mJgAFSUTC1AjbjaxCDvE7Sa2oM3zJrZCg3jWxDZ4XPxTE0vwmfiBie2wxfIDE1fAo5YbJq6EXZb/MnEVPGfdZuJqWMCVKuMaOGQ725nNncxnRtM6/T5tbWnZSfu1FA2rehPtnkh66b6xMcrVBZrXClp+Skt56YHujmD/vsHu3mdopoCHWT2vprRxNf88zY6s9j+QGdbyqp7JTtABLZ8Z6ddGJ8fU/L5CUptIaXnaTB+0eFA+pOULTNjmbdlxX/eg6ZekgbmPZgq6lkcyM0Gj3gEvjai6NqFTdSJFB5cde0dGMkmNk0ktr6tonNXTmOjxyXymkMok2WgF73L+ndl8LmumpGtTGj2o6rpWyE6kdT23x+c7ceKEVzWNk2jrTWbHfV+k00/mtJRWyIxO4Ly9aX18LFrQ2Hz0NM5xxYxHsph8ITuin1DzGpt/YXL4uJbUqZ5FW42O4Twm0FUdzWvaOJvpJM/4RDqTTNOT2UmqJpNaTseKMPPPi+z9omTHlp14ptAJWcjBScjj6+oovr7pQOH7+GuFFvzsRNQPGqSwD4OK2iZE3Xi7JsGLiL3SjWF/37vAJQ17Dfsp7sssD6BXBwQx2j4YRNwLzyCb4fYq/nS0VtFWw5daFfHzyGXxNfSLxj+A/sN8HKbJoP0Eagc4k0Ff5jmKfydjPOI+HCuJzAQfJY+WzTyvL47xZfpDHBWWNdswrxbY8VC/L4v6v6tGue6jPIrOY5ctMzx2FC0GuFWEe7I66Hy0CW41+JARe3HEEfRnVbtvmeSxdZTLkbOI02ZFj2O18zyDFPdbmlsBR/7t+rO9l8fdl32gSiy7KT7mQc7rfD8xXZpLOdiDjxkfnOAfL9qsjpw043o5GkfL39VPxzsjx+uo8TUeRdvyent5zHHcW1G+15fWh9WivI4PX+MR3rPKF7iHjpmofK2W1r+ANRzGSmq8fixi1ozLbMbM9ZgwR1UxJ+bN1m1pTSdX1PgEzyeJV4pzyaKO+SR5jByvbGpF9P9pzt7fubJjDxnpfk3xacfbohsDPKSVKhLvEwmfznv59Tqx+ONk7h756B6h98ipX5PIr8n0nfN3hP+4vdV1+fb120LvrWO3Lt8SW24Rxy08ucw75yPzifnc/FvztjWOm6QK/p3U/uvcLtcnbTei/9z2cRRukPbIjekbxg2RHQmHbtgrQzeIGP1YrHc5Z+lsy2xudnr2J7Nzs7dn7dPvn39f+JtrPpfjmuua4Lrae/XUVTHxNnG87XpbiLyZeFM4f5E4Lrou+i6Kf3zB67rQ9bjrjdc3u+Zev/26wMJvf726NnTsu+TUt177lpB7dfrV86+K06+cf0W4PHV9SihEtrqyEx7XRNfvuTa0NUSlNjFqExddzDMw3LgllDjmdx1Do8NDLa6hrq2uR9rWRq2YrAUNHaJL3Cv2ilnxNfG6KNn7I4+7+vA3F7kdERy9rl5fr8iO8GqPGwPtz+2f3i92h7a6wl27XI4uV5ev66OuT7puddmOdZFL+A1dDl0Pif7QVl/IH3rcHXo0LEfr2+qizjZHVCAQJW0Q9TkWHYIDXxVOOdiBGYTpemIlM+R8aXDA4+mZkRb7ewx75LBBzhiNA+zq7xsybGcMiA4djpUI+cP4K+fOQcdjPUbrQMxIPBbvMVII/AxMI3A+VqqHjnihoLNzt4d4PAgn8QqeSaSOFsokeJbU4CmQQgEKBeJhOg6RgYKH0YxhPgQ9jxaAXZjWw60YKhQajv43dZSJxwplbmRzdHJlYW0KZW5kb2JqCgo2IDAgb2JqCjM1MDMKZW5kb2JqCgo3IDAgb2JqCjw8L1R5cGUvRm9udERlc2NyaXB0b3IvRm9udE5hbWUvQkFBQUFBK0xpYmVyYXRpb25TZXJpZgovRmxhZ3MgNAovRm9udEJCb3hbLTE3NiAtMzAzIDEwMDUgOTgxXS9JdGFsaWNBbmdsZSAwCi9Bc2NlbnQgODkxCi9EZXNjZW50IC0yMTYKL0NhcEhlaWdodCA5ODEKL1N0ZW1WIDgwCi9Gb250RmlsZTIgNSAwIFIKPj4KZW5kb2JqCgo4IDAgb2JqCjw8L0xlbmd0aCAyMjMvRmlsdGVyL0ZsYXRlRGVjb2RlPj4Kc3RyZWFtCnicXZBBT8QgEIXv/Io57h420D14apromk16cDVWfwCFaSWxA5nSQ/+9U6yaeIDk8d4Hb9CX9rGlkPULR9dhhiGQZ5zjwg6hxzGQqs7gg8u7KrubbFJa2G6dM04tDbGulX4Vb868wuHexx6PSj+zRw40wuH90onulpQ+cULKYFTTgMdB7nmy6WYn1IU6tV7skNeTIH+BtzUhnIuuvqu46HFO1iFbGlHVxjRQX6+NQvL/vJ3oB/dhWZKVJI25eyjZ/XSjtrF+2oBbmKVJmb1U2B4PhL/fk2LaqLK+AIPPbYsKZW5kc3RyZWFtCmVuZG9iagoKOSAwIG9iago8PC9UeXBlL0ZvbnQvU3VidHlwZS9UcnVlVHlwZS9CYXNlRm9udC9CQUFBQUErTGliZXJhdGlvblNlcmlmCi9GaXJzdENoYXIgMAovTGFzdENoYXIgMQovV2lkdGhzWzM2NSA1MDAgXQovRm9udERlc2NyaXB0b3IgNyAwIFIKL1RvVW5pY29kZSA4IDAgUgo+PgplbmRvYmoKCjEwIDAgb2JqCjw8L0YxIDkgMCBSCj4+CmVuZG9iagoKMTEgMCBvYmoKPDwvRm9udCAxMCAwIFIKL1Byb2NTZXRbL1BERi9UZXh0XQo+PgplbmRvYmoKCjEgMCBvYmoKPDwvVHlwZS9QYWdlL1BhcmVudCA0IDAgUi9SZXNvdXJjZXMgMTEgMCBSL01lZGlhQm94WzAgMCA2MTIgNzkyXS9Hcm91cDw8L1MvVHJhbnNwYXJlbmN5L0NTL0RldmljZVJHQi9JIHRydWU+Pi9Db250ZW50cyAyIDAgUj4+CmVuZG9iagoKNCAwIG9iago8PC9UeXBlL1BhZ2VzCi9SZXNvdXJjZXMgMTEgMCBSCi9NZWRpYUJveFsgMCAwIDYxMiA3OTIgXQovS2lkc1sgMSAwIFIgXQovQ291bnQgMT4+CmVuZG9iagoKMTIgMCBvYmoKPDwvVHlwZS9DYXRhbG9nL1BhZ2VzIDQgMCBSCi9PcGVuQWN0aW9uWzEgMCBSIC9YWVogbnVsbCBudWxsIDBdCi9MYW5nKGVuLVVTKQo+PgplbmRvYmoKCjEzIDAgb2JqCjw8L0NyZWF0b3I8RkVGRjAwNTcwMDcyMDA2OTAwNzQwMDY1MDA3Mj4KL1Byb2R1Y2VyPEZFRkYwMDRDMDA2OTAwNjIwMDcyMDA2NTAwNEYwMDY2MDA2NjAwNjkwMDYzMDA2NTAwMjAwMDMzMDAyRTAwMzU+Ci9DcmVhdGlvbkRhdGUoRDoyMDEyMTIyMDExMTgyOSswMScwMCcpPj4KZW5kb2JqCgp4cmVmCjAgMTQKMDAwMDAwMDAwMCA2NTUzNSBmIAowMDAwMDA0NTM0IDAwMDAwIG4gCjAwMDAwMDAwMTkgMDAwMDAgbiAKMDAwMDAwMDE3MCAwMDAwMCBuIAowMDAwMDA0Njc3IDAwMDAwIG4gCjAwMDAwMDAxODkgMDAwMDAgbiAKMDAwMDAwMzc3NiAwMDAwMCBuIAowMDAwMDAzNzk3IDAwMDAwIG4gCjAwMDAwMDM5OTIgMDAwMDAgbiAKMDAwMDAwNDI4NCAwMDAwMCBuIAowMDAwMDA0NDQ3IDAwMDAwIG4gCjAwMDAwMDQ0NzkgMDAwMDAgbiAKMDAwMDAwNDc3NiAwMDAwMCBuIAowMDAwMDA0ODczIDAwMDAwIG4gCnRyYWlsZXIKPDwvU2l6ZSAxNC9Sb290IDEyIDAgUgovSW5mbyAxMyAwIFIKL0lEIFsgPDY1RTI2N0YzRTMwMjIyRkMwM0I5MjY3ODU4NUU0Njg4Pgo8NjVFMjY3RjNFMzAyMjJGQzAzQjkyNjc4NTg1RTQ2ODg+IF0KL0RvY0NoZWNrc3VtIC9FQjU4MjMwQzk4RkZEQzczNDJERDI3MzE1MEM3MTkyNgo+PgpzdGFydHhyZWYKNTA0OAolJUVPRgo=';

	/**
	 * @expectedException \Dalten\Util\Base64\Exception\InvalidFormat
	 */
	public function testThrowInvalidFormatException()
	{
		Base64::decode("die('pičo');");
	}

	public function testDecodeAndReturnJpegMimeType()
	{
		if (!class_exists('finfo', false)) {
			$this->markTestSkipped('Chybí rozšíření finfo.');
		}
		$decoder = Base64::decode($this->_jpgImage);
		$this->assertEquals('image/jpeg', $decoder->getMimeType());
	}

	public function testDecodeAndReturnPngMimeType()
	{
		if (!class_exists('finfo', false)) {
			$this->markTestSkipped('Chybí rozšíření finfo.');
		}
		$decoder = Base64::decode($this->_pngImage);
		$this->assertEquals('image/png', $decoder->getMimeType());
	}

	public function testDecodeAndReturnPdfMimeType()
	{
		if (!class_exists('finfo', false)) {
			$this->markTestSkipped('Chybí rozšíření finfo.');
		}
		$decoder = Base64::decode($this->_pdf);
		$this->assertEquals('application/pdf', $decoder->getMimeType());
	}

}
