<?php
namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Mockery as m;

class PreviousBreadcrumbAndCountyAndRegionTest extends \PHPUnit_Framework_TestCase
{

	public function testBuilderAddsRegionInformationToBreadcrumbWhenCreatedFromListing()
	{
		$listing = new Listing();
		$listing->listing_locality_county_code = 7;
		$listing->listing_locality_prague_district_code = 1;
		$breadcrumb = new Breadcrumb('x', 'route', array('x' => 'y', 'county' => 'bagr'));
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\PreviousBreadcrumbAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromListing')->with($listing)->once()->andReturn($breadcrumb);
		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$helper->shouldReceive('getBreadcrumb')->with($breadcrumb, array(7), 1)->once()
			->andReturn('success');
		$builder = new PreviousBreadcrumbAndCountyAndRegion($previousBuilder, $helper);

		$this->assertSame('success', $builder->getBreadcrumbFromListing($listing));
	}


	public function testBuilderRetunsNullIfNoPreviousBreadcrumbWasFound()
	{
		$listing = new Listing();
		$listing->listing_locality_county_code = 7;
		$filter = new ListingFilter(
			array(),
			array(new AddressFilter(7, array(1)))
		);

		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\PreviousBreadcrumbAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromListing')->with($listing)->once()->andReturn(null);
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->once()->andReturn(null);
		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->never();
		$helper->shouldReceive('getBreadcrumb')->never();
		$builder = new PreviousBreadcrumbAndCountyAndRegion($previousBuilder, $helper);

		$this->assertNull($builder->getBreadcrumbFromFilter($filter));
		$this->assertNull($builder->getBreadcrumbFromListing($listing));
	}

	public function testBuilderAddsRegionInformationToBreadcrumbWhenCreatedFromFilter()
	{

		$filter = new ListingFilter(
			array(),
			array(new AddressFilter(7, array(1)))
		);

		$breadcrumb = new Breadcrumb('x', 'route', array('x' => 'y', 'county' => 'bagr'));
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\PreviousBreadcrumbAndCounty');
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->once()->andReturn($breadcrumb);

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->with($filter, $breadcrumb)->once()
			->andReturn('success');
		$builder = new PreviousBreadcrumbAndCountyAndRegion($previousBuilder, $helper);

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}
}
