<?php

namespace Dalten\Tests\WebBundle\Filter;


use Dalten\WebBundle\Filter\Base;

class BaseTest extends \PHPUnit_Framework_TestCase
{
	/**
	 * @expectedException \Dalten\WebBundle\Filter\Exception\PropertyDoesNotExist
	 */
	public function testGetUndefinedPropertyAndThrowException()
	{
		$filter = new Base(array());
		$filter->blah;
	}

	public function testGetProperty()
	{
		$propertyValue = 'value';
		$filter = new Base(array('property' => $propertyValue));

		$this->assertEquals($propertyValue, $filter->property);
	}

	public function testIsset()
	{
		$filter = new Base(array('property' => 'value', 'emptyProperty' => null));

		$this->assertFalse(isset($filter->blah));
		$this->assertTrue(isset($filter->property));
		$this->assertFalse(isset($filter->emptyProperty));
	}

	public function testToArrayReturnsInternalArray()
	{
		$input = array('property' => 'value', 'emptyProperty' => null);
		$filter = new Base($input);

		$this->assertSame($input, $filter->toArray());
	}
}
