<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Karel
 * Date: 18.10.13
 * Time: 11:35
 * To change this template use File | Settings | File Templates.
 */

namespace Dalten\Tests\WebBundle\Filter;


use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\BrokerFilter;

class BrokerFilterTest extends \PHPUnit_Framework_TestCase
{
	/**
	 * @expectedException \Dalten\WebBundle\Filter\Exception\PropertyDoesNotExist
	 */
	public function testOnlySpecifiedPropertiesAreAllowed()
	{
		$filter = new BrokerFilter(array('known_languages' => array(1)));

		$filter->nonexistant;
	}

	public function testFilterDiscardsUndefinedProperties()
	{
		$filter = new BrokerFilter(array('bagr' => array(1)));

		$this->assertFalse(isset($filter->bagr));
	}

	public function testPropertiesCanBeRetrieved()
	{
		$input = array(
			'known_languages' => array(1),
			'listing_type_specialisation' => array(2),
			'advert_type_specialisation' => array(3)
		);
		$filter = new BrokerFilter($input);

		$this->assertSame($input['known_languages'], $filter->known_languages);
		$this->assertSame($input['listing_type_specialisation'], $filter->listing_type_specialisation);
		$this->assertSame($input['advert_type_specialisation'], $filter->advert_type_specialisation);
	}

	public function testPropertyConversionToArray()
	{
		$filter = new BrokerFilter(array('advert_type_specialisation' => array(1)));
		$this->assertSame(array(1), $filter->advert_type_specialisation);
		$filter = new BrokerFilter(array('advert_type_specialisation' => 3));
		$this->assertSame(array(3), $filter->advert_type_specialisation);
	}

	public function testPropertyConversionToMultiOption()
	{
		$filter = new BrokerFilter(array('advert_type_specialisation' => '1'));
		$this->assertSame(array(1), $filter->advert_type_specialisation);
		$filter = new BrokerFilter(array('advert_type_specialisation' => array('3')));
		$this->assertSame(array(3), $filter->advert_type_specialisation);

		$filter = new BrokerFilter(array('advert_type_specialisation' => array('bagr')));
		$this->assertSame(array(\intval('bagr')), $filter->advert_type_specialisation);
	}

	public function testPropertyConversionToString()
	{
		$filter = new BrokerFilter(array('search_text' => 'test'));
		$this->assertSame('test', $filter->search_text);
		$filter = new BrokerFilter(array('search_text' => 1));
		$this->assertSame('1', $filter->search_text);
	}

	public function testFilterCanAcceptsAndRetrieveAddressFilters()
	{
		$address = new AddressFilter(5, array());
		$filter = new BrokerFilter(array(), array($address));
		$this->assertSame(array($address), $filter->getAddressFilters());
	}

	/**
	 * @expectedException \Dalten\WebBundle\Filter\Exception\InvalidAddressFilter
	 */
	public function testFilterThrowsExceptionIfInvalidFiltersArePassedIn()
	{
		new BrokerFilter(array(), array(array()));
	}
}
