<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Karel
 * Date: 18.10.13
 * Time: 11:35
 * To change this template use File | Settings | File Templates.
 */

namespace Dalten\Tests\WebBundle\Filter;


use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\CompanyFilter;

class CompanyFilterTest extends \PHPUnit_Framework_TestCase
{
	/**
	 * @expectedException \Dalten\WebBundle\Filter\Exception\PropertyDoesNotExist
	 */
	public function testOnlySpecifiedPropertiesAreAllowed()
	{
		$filter = new CompanyFilter(array('search_text' => 'text'));

		$filter->nonexistant;
	}

	public function testFilterDiscardsUndefinedProperties()
	{
		$filter = new CompanyFilter(array('bagr' => array(1)));

		$this->assertFalse(isset($filter->bagr));
	}

	public function testPropertiesCanBeRetrieved()
	{
		$input = array(
			'search_text' => 'text',
		);
		$filter = new CompanyFilter($input);

		$this->assertSame($input['search_text'], $filter->search_text);
	}

	public function testPropertyConversionToString()
	{
		$filter = new CompanyFilter(array('search_text' => 'test'));
		$this->assertSame('test', $filter->search_text);
		$filter = new CompanyFilter(array('search_text' => 1));
		$this->assertSame('1', $filter->search_text);
	}

	public function testFilterCanAcceptsAndRetrieveAddressFilters()
	{
		$address = new AddressFilter(5, array());
		$filter = new CompanyFilter(array(), array($address));
		$this->assertSame(array($address), $filter->getAddressFilters());
	}

	/**
	 * @expectedException \Dalten\WebBundle\Filter\Exception\InvalidAddressFilter
	 */
	public function testFilterThrowsExceptionIfInvalidFiltersArePassedIn()
	{
		new CompanyFilter(array(), array(array()));
	}
}
