<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 8. 12. 2014
 * Time: 15:27
 */

namespace Dalten\WebBundle\Tests\Processor\SeoUrl;


use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Processor\SeoUrl\AddressSlugGenerator;

class AddressSlugGeneratorTest extends \PHPUnit_Framework_TestCase
{
	private $_counties = array(7 => 'bagr', 5 => 'kolobezka');
	private $_regions = array(7 => array(99 => 'motor'), 5 => array(5 => 'přední kolo', 7 => 'řidítka'));

	public function testGeneratorCanFindCountySlugInFilter()
	{
		$filter = new CompanyFilter(array(), array(new AddressFilter(7, array())));
		$generator = new AddressSlugGenerator($this->_counties, $this->_regions);

		$this->assertSame(array('county' => 'bagr'), $generator->getAddressUrlParams($filter));
	}

	public function testGeneratorCanFindCountyAndRegionSlugsInFilter()
	{
		$filter = new CompanyFilter(array(), array(new AddressFilter(7, array(99))));
		$generator = new AddressSlugGenerator($this->_counties, $this->_regions);

		$this->assertSame(array('county' => 'bagr', 'region' => 'motor'), $generator->getAddressUrlParams($filter));
	}

	public function testGeneratorReturnsEmptyArrayIfMoreThanOneAddressFilterIsPresent()
	{
		$filter = new CompanyFilter(array(), array(new AddressFilter(7, array(99)), new AddressFilter(5, array())));
		$generator = new AddressSlugGenerator($this->_counties, $this->_regions);

		$this->assertSame(array(), $generator->getAddressUrlParams($filter));
	}

	public function testGeneratorReturnsEmptyArrayIfMoreThanOneRegionCodeIsPresent()
	{
		$filter = new CompanyFilter(array(), array(new AddressFilter(5, array(5, 7))));
		$generator = new AddressSlugGenerator($this->_counties, $this->_regions);

		$this->assertSame(array(), $generator->getAddressUrlParams($filter));
	}

	public function testGeneratorReturnsEmptyArrayIfNoAddressFilterIsPresent()
	{
		$filter = new CompanyFilter(array());
		$generator = new AddressSlugGenerator($this->_counties, $this->_regions);

		$this->assertSame(array(), $generator->getAddressUrlParams($filter));
	}

	public function testGeneratorCanUseSpecialPresetSlugs()
	{
		$filter = new CompanyFilter(array(), array(new AddressFilter(1, array(2, 3))));
		$specialSlugs = array(
			array('requirements' => array(1 => array(2, 3)), 'slugs' => array('county' => 'x', 'region' => 'y'))
		);
		$generator = new AddressSlugGenerator($this->_counties, $this->_regions, $specialSlugs);

		$this->assertSame(array('county' => 'x', 'region' => 'y'), $generator->getAddressUrlParams($filter));
	}
}
