# WebAdmin

nový admin pro Daltenweby - **verze 2**.

Tato verze počítá s tím, že na webu budou extendovány soubory entit. 

Stále ve vývoji. ;-)

## Instalace

1. nainstalujte WebAdmin - `composer require dalten/webadmin:^2`
2. přidejte patřičnou konfiguraci podle níže uvedených příkladů, nastavte SwiftMailer, FosUserBundle a DaltenWebBundle
3. zapněte WebAdminBundle a jeho závislosti
4. `composer install`, WebAdmin se pokusí nastavit své závislosti podle configu `other_bundles.yml` 
5. Profit? Tříprsťák!

### Dědění entit

Protože není možné mít v projektu více definic entity pro stejnou tabulku, entity webu se postupně dědí od `WebBundle` a `WebAdminBundle`.

Z technických důvodů není možné mít ve `WebBundle` definované asociace na ostatní entity, musí se definovat až u samotného webu.

Proto je důležité na webu důsledně používat entity samotného webu (`FrontBundle`), pokud někde zapomenete entity z `WebBundle`, nebudou vám fungovat asociace.

```
<?php
namespace FrontBundle\Entity;

use Dalten\WebBundle\Entity\Listing as WebListing;
use Doctrine\ORM\Mapping as ORM;
use Dalten\WebBundle\Entity\ListingAttachment;
use FrontBundle\Entity\DevProject;
use FrontBundle\Entity\Broker;

/**
 * @ORM\Entity
 * @ORM\Table(name="nabidka", indexes={@ORM\Index(name="nemovitost_titulek", columns={"nemovitost_titulek"})})
 */
class Listing extends WebListing
{
    /**
     * @var ListingAttachment[]
     * 
     * @ORM\OneToMany(targetEntity="Dalten\WebBundle\Entity\ListingAttachment", mappedBy="listing", fetch="EAGER")
     */
    protected $attachments = [];

    /**
     * @var DevProject
     * 
     * @ORM\ManyToOne(targetEntity="FrontBundle\Entity\DevProject", inversedBy="listings")
     * @ORM\JoinColumn(name="id_projekt")
     */
    protected $project;

    /**
     * @var Broker
     * 
     * @ORM\OneToOne(targetEntity="FrontBundle\Entity\Broker",fetch="EAGER")
     * @ORM\JoinColumn(name="id_uzivatel")
     */
    protected $broker;
}
```

```
<?php
namespace FrontBundle\Entity;

use Dalten\WebBundle\Entity\DevProject as WebDevProject;
use Doctrine\ORM\Mapping as ORM;
use Dalten\WebBundle\Entity\DevProjectAttachment;
use FrontBundle\Entity\Listing;
use FrontBundle\Entity\Broker;

/**
 * @ORM\Entity
 * @ORM\Table(name="projekt")
 */
class DevProject extends WebDevProject
{
    /**
     * @var DevProjectAttachment[]
     * 
     * @ORM\OneToMany(targetEntity="Dalten\WebBundle\Entity\DevProjectAttachment", mappedBy="project", fetch="EAGER")
     */
    protected $attachments = [];

    /**
     * @var Listing[]
     * 
     * @ORM\OneToMany(targetEntity="FrontBundle\Entity\Listing", mappedBy="project", fetch="EAGER")
     */
    protected $listings = [];

    /**
     * @var Broker
     * 
     * @ORM\OneToOne(targetEntity="FrontBundle\Entity\Broker")
     * @ORM\JoinColumn(name="id_uzivatel")
     */
    protected $broker;
}
```

### Příklad konfigurace webu

Následující kusy kódu přidejte do patřičných konfigů. V případě potřeby je upravte.

#### `AppKernel.php`

```
	        new Dalten\WebAdminBundle\DaltenWebAdminBundle(),
	        new Stfalcon\Bundle\TinymceBundle\StfalconTinymceBundle(),
	        new FM\ElfinderBundle\FMElfinderBundle(),
	        new FOS\UserBundle\FOSUserBundle(),
	        new Dalten\WebAdminLoginBundle\DaltenWebAdminLoginBundle()
```

#### `composer.json`

```
{
	// ...
	"config": {
		// ...
		"component-dir": "web/assets"
	}
}
```

#### `parameters.yml`

```
dalten_web_admin.allowed_pages: {}
```

Zde je dále možné zapnout nastavit features zdokumentované v `dalten_web_admin.yml`.

#### `config.yml`

```
twig:
    # ...
    globals:
        # ...
        allowed_pages: '%dalten_web_admin.allowed_pages%'

# ..
        
fos_user:
    db_driver: orm # other valid values are 'mongodb' and 'couchdb'
    firewall_name: main
    user_class: Dalten\WebAdminBundle\Entity\User
    from_email:
        address: "noreply@dalten.cz"
        sender_name: "Webadmin"        
```

#### `routing.yml`

```
dalten_web_admin:
    resource: "@DaltenWebAdminBundle/Resources/config/routing.yml"
    prefix:   /webadmin

fos_user:
    resource: "@FOSUserBundle/Resources/config/routing/all.xml"

elfinder:
     resource: "@FMElfinderBundle/Resources/config/routing.yml"
```

#### `security.yml`

```
security:
    encoders:
        FOS\UserBundle\Model\UserInterface: bcrypt
        Symfony\Component\Security\Core\User\User: plaintext

    role_hierarchy:
        ROLE_ADMIN:       ROLE_USER
        ROLE_SUPER_ADMIN: ROLE_ADMIN

    providers:
        chain_provider:
          chain:
            providers: [in_memory, fos_userbundle]
        in_memory:
          memory:
            users:
              dalten: { password: h3s1Opr0webadm1n, roles: [ ROLE_ADMIN ] }
        fos_userbundle:
            id: fos_user.user_provider.username

    firewalls:
        main:
            pattern: ^/
            form_login:
                provider: chain_provider
                csrf_token_generator: security.csrf.token_manager
                default_target_path: /webadmin

            logout:       true
            anonymous:    true

    access_control:
        - { path: ^/login$, roles: IS_AUTHENTICATED_ANONYMOUSLY }
        - { path: ^/register, roles: IS_AUTHENTICATED_ANONYMOUSLY }
        - { path: ^/resetting, roles: IS_AUTHENTICATED_ANONYMOUSLY }
        - { path: ^/changed-password, roles: IS_AUTHENTICATED_ANONYMOUSLY }
        - { path: ^/webadmin/user/, roles: ROLE_ADMIN }
        - { path: ^/webadmin/, roles: ROLE_USER }
        - { path: ^/elfinder/, roles: ROLE_USER }
        - { path: ^/efconnect/, roles: ROLE_USER }
```

## Schopnosti

- správa sekcí
- správa článků (s udržováním historie)
- správa novinek
- správa profilů makléře
- správa souborů (příloh ke článkům)
- správa menu
- správa bannerů
- správa hodnot nastavení
- přidávání a přehled uživatelů webadminu
- překlady článků
