<?php

namespace Dalten\WebAdminBundle\Controller;

use Doctrine\ORM\EntityManager;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use FrontBundle\Entity\Blogpost;
use Dalten\WebAdminBundle\Form\BlogpostType;

use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * Blogpost controller.
 *
 */
class BlogpostController extends Controller
{
    /**
     * Lists all Blogpost entities.
     *
     */
    public function indexAction(Request $request)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $em = $this->getDoctrine()->getManager();

        $qb = $this->get('doctrine.orm.entity_manager')->createQueryBuilder();
		$qb->select('b')->from('DaltenWebAdminBundle:Blogpost', 'b');

		$pager = $this->_paginate($qb, 100, $request->get('page', 1));

        return $this->render('DaltenWebAdminBundle:blogpost:index.html.twig', array(
            'blogposts' => $pager,
			'paging' => $pager
        ));
    }

    /**
     * Creates a new Blogpost entity.
     *
     */
    public function newAction(Request $request)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $blogpost = new Blogpost();
		$blogpost->setDatePublished(new \DateTime('now'));
        $form = $this->createForm($this->getParameter('dalten_web_admin.form.blogpost.class'), $blogpost, ['broker_selection'=>$this->getParameter('dalten_web_admin.broker_selection')]);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();

			$blogpost = $this->_checkSlugDuplicity($em, $blogpost);

            $em->persist($blogpost);
            $em->flush();

            return $this->redirectToRoute('webadmin_blogpost_index');
        }

        return $this->render('DaltenWebAdminBundle:blogpost:new.html.twig', array(
            'blogpost' => $blogpost,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Blogpost entity.
     *
     */
    public function showAction(Blogpost $blogpost)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $deleteForm = $this->createDeleteForm($blogpost);

        return $this->render('DaltenWebAdminBundle:blogpost:show.html.twig', array(
            'blogpost' => $blogpost,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Blogpost entity.
     *
     */
    public function editAction(Request $request, Blogpost $blogpost)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $deleteForm = $this->createDeleteForm($blogpost);
        $editForm = $this->createForm($this->getParameter('dalten_web_admin.form.blogpost.class'), $blogpost, ['broker_selection'=>$this->getParameter('dalten_web_admin.broker_selection')]);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $em = $this->getDoctrine()->getManager();

			$blogpost = $this->_checkSlugDuplicity($em, $blogpost);

            $em->persist($blogpost);
            $em->flush();

            return $this->redirectToRoute('webadmin_blogpost_index');
        }

        return $this->render('DaltenWebAdminBundle:blogpost:edit.html.twig', array(
            'blogpost' => $blogpost,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Blogpost entity.
     *
     */
    public function deleteAction(Request $request, Blogpost $blogpost)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $form = $this->createDeleteForm($blogpost);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($blogpost);
            $em->flush();
        }

        return $this->redirectToRoute('webadmin_blogpost_index');
    }

    /**
     * Creates a form to delete a Blogpost entity.
     *
     * @param Blogpost $blogpost The Blogpost entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Blogpost $blogpost)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('webadmin_blogpost_delete', array('id' => $blogpost->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

	/**
	 * @param     $dql
	 * @param int $pageSize
	 * @param int $currentPage
	 *
	 * @return Paginator
	 */
	protected function _paginate($dql, $pageSize = 10, $currentPage = 1)
	{
		$paginator = new Paginator($dql);

		$paginator
			->getQuery()
			->setFirstResult($pageSize * ($currentPage - 1)) // set the offset
			->setMaxResults($pageSize); // set the limit

		$paginator->recordsOnPage = $pageSize;
		$paginator->recordCount = count($paginator);
		$paginator->current = $currentPage;
		$paginator->pageCount = ceil($paginator->recordCount / $pageSize);

		return $paginator;
	}

	/**
	 * Zajistí, aby nebyl duplikátní slug entity.
	 *
	 * @param EntityManager $em     Doctrine EntityManager.
	 * @param object        $entity Entita, u které chcem hlídat unikátnost slugu.
	 *
	 * @return object entita s opraveným slugem
	 */
	protected function _checkSlugDuplicity(EntityManager $em, $entity)
	{
		// popis chování:
        // - slug měníme pouze pokud ho článek nemá
        // - pokud najdeme článek s duplicitním slugem, vygenerujeme slug~N, kde N je první nepoužité číslo

        if (empty($entity->getSlug()) && method_exists($entity, 'regenerateSlug')) {
			$entity->regenerateSlug();
		}
        $slug = $originalSlug = $entity->getSlug();
        $id = $entity->getId() ? $entity->getId() : 0;

        $connection = $em->getConnection();

		$i = 0;

		$duplicate = true;
		// když najdeme duplikát
		// zkusíme zda existuje slug~n
		// inkremenuteme n dokud nenajdem nepoužitý slug
		while($duplicate) {
            // TODO: tady nemít nadrátovaný název tabulky
			$duplicate = $connection->executeQuery('SELECT id FROM blogpost WHERE slug=? AND id!=?', [$slug, $id])->fetch();
			if ($duplicate) {
				$i++;
				$slug = $originalSlug.'~'.$i;
			}
        }
        
        if ($slug!=$originalSlug) {
            $entity->setSlug($slug);
        }

		return $entity;
	}
}
