<?php

namespace Dalten\WebAdminBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\Yaml\Parser as YamlParser;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 *
 * @link https://symfony.com/doc/2.8/bundles/prepend_extension.html
 */
class DaltenWebAdminExtension extends Extension implements PrependExtensionInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
	    // zvaliduje uživatelskou konfiguraci
	    $configuration = new Configuration();
	    $userConfig = $this->processConfiguration($configuration, $configs);

	    // načte výchozí konfig
	    $parser = new YamlParser();
	    $defaultConfig = $parser->parse(file_get_contents(__DIR__ . '/../Resources/config/dalten_web_admin.yml'));

	    // zapíše konfiguraci do kontejneru
	    foreach ($defaultConfig['dalten_web_admin'] as $key=>$value) {
		    if (isset($userConfig[$key])) {
			    $value = $userConfig[$key];
		    }
		    $container->setParameter('dalten_web_admin.'.$key, $value);
	    }

	    // načte services
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');
    }

	public function prepend(ContainerBuilder $container)
	{
		// načte other_bundles.yml
		$parser = new YamlParser();
		$otherBundlesConfig = $parser->parse(file_get_contents(__DIR__ . '/../Resources/config/other_bundles.yml'));

		// a pokusí se ho podstrčit jako výchozí config pro bundly na kterých webadmin závisí
		foreach ($container->getExtensions() as $name => $extension) {
			if (isset($otherBundlesConfig[$name])) {
				$container->prependExtensionConfig($name, $otherBundlesConfig[$name]);
			}
		}
	}

}
