<?php

namespace Dalten\WebAdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class ArticleType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'name',
                'Symfony\Component\Form\Extension\Core\Type\TextType',
                ['label' => 'Název', 'constraints' => new NotBlank()]
            )
            ->add(
                'teaser',
                'Symfony\Component\Form\Extension\Core\Type\TextareaType',
                ['label' => 'Upoutávka', 'required' => false]
            )
            ->add(
                'html',
                'Symfony\Component\Form\Extension\Core\Type\TextareaType',
                ['attr' => array('class' => 'tinymce'), 'label' => 'Text článku']
            )
            ->add('idSection', null, ['label' => 'Sekce', 'required' => false])
            ->add(
                'oldSlug',
                'Symfony\Component\Form\Extension\Core\Type\TextType',
                ['label' => 'Slug na starém webu', 'attr' => ['placeholder' => 'Např. o-nas.htm'], 'required' => false]
            );
        if ($options['broker_selection']) {
            $builder
                ->add('broker', 'entity', [
                    'label' => 'Makléř',
                    'required' => false,
                    'class' => 'FrontBundle\Entity\Broker',
                    'empty_value' => '- nevybráno -',
                    'choices_as_values' => true
                ]);
        }
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Dalten\WebAdminBundle\Entity\Article',
            'broker_selection' => false
        ));
    }
}
