<?php
namespace Dalten\WebAdminBundle\Processor;
use Dalten\WebAdminBundle\Entity\MenuItem;

class MenuBuilder
{
	/** @var \Doctrine\ORM\EntityManagerInterface  */
	protected $_em;

	public function __construct($em)
	{
		$this->_em = $em;
	}

	protected function _getUrl(MenuItem $menuItem)
	{
		if ($menuItem->getArticle()) {
			return $menuItem->getArticle()->getSlug();
		}
		return $menuItem->getUrl();
	}

	/**
	 * Získá položky menu pomocí JOINu.
	 *
	 * @return array Položky menu.
	 */
	protected function _getItems()
	{
		$qb = $this->_em->createQueryBuilder();

		$qb->select(['m', 'a'])
			->from('\Dalten\WebAdminBundle\Entity\MenuItem', 'm')
			->leftJoin('m.article', 'a')
			->orderBy('m.rank', 'ASC');

		return $qb->getQuery()->getResult();
	}

	/**
	 * Sestaví dvouúrovňové menu.
	 *
	 * @return array
	 */
	public function buildTwoLevel()
	{
		$menuItems = $this->_getItems();

		// tohle je asi nejjednodušší metoda stavby stromu

		$itemsByParent = array(0 => array() );

		foreach ($menuItems as $item) {
			$parentId = 0;
			if ($item->getParentId()) {
				$parentId = $item->getParentId();
			}

			$itemsByParent[$parentId][] = array(
				'id' => $item->getId(),
				'title' => $item->getTitle(),
				'url' => $this->_getUrl($item),
				'article' => $item->getArticle(),
				'children' => array()
			);
		}

		$ret = array();

		// pokud bych chtěl sestavit celý strom, bylo by to tady rekurzivní
		foreach ($itemsByParent[0] as $item) {
			$itemId = $item['id'];
			if (isset($itemsByParent[$itemId])) {
				$item['children'] = $itemsByParent[$itemId];
			}
			$ret[] = $item;
		}

		return $ret;
	}

	/**
	 * Sestaví stromovou strukturu menu.
	 *
	 * @return mixed
	 */
	public function build()
	{
		$menuItems = $this->_getItems();

		// tohle je asi nejjednodušší metoda stavby stromu

		$itemsByParent = array(0 => array() );

		foreach ($menuItems as $item) {
			$parentId = 0;
			if ($item->getParentId()) {
				$parentId = $item->getParentId();
			}

			// přetypováváme na objekt, phpková pole neumožňují nastavovat reference na jiná pole
			$itemsByParent[$parentId][] = (object) array(
				'id' => $item->getId(),
				'title' => $item->getTitle(),
				'url' => $this->_getUrl($item),
				'article' => $item->getArticle(),
				'children' => array()
			);
		}

		// procházíme všechny položky a nastavuje ->children na odpovídající objekt
		foreach ($itemsByParent as $parentId=>$itemCollection) {
			foreach ($itemCollection as $rank=>$item) {
				$itemId = $item->id;
				if (!empty($itemsByParent[$itemId])) {
					$itemsByParent[$parentId][$rank]->children = $itemsByParent[$itemId];
				}
			}
		}

		return $itemsByParent[0];
	}

}