<?php

namespace Dalten\WebAdminBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Dalten\WebAdminBundle\Entity\User;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * User controller.
 *
 */
class UserController extends Controller
{
    /**
     * Lists all User entities.
     *
     */
    public function indexAction()
    {
		$this->denyAccessUnlessGranted('ROLE_ADMIN', null, 'Only for admins.');

        $em = $this->getDoctrine()->getManager();

        $users = $em->getRepository('DaltenWebAdminBundle:User')->findAll();

        return $this->render('DaltenWebAdminBundle:user:index.html.twig', array(
            'users' => $users,
        ));
    }

    /**
     * Creates a new User entity.
     *
     */
    public function newAction(Request $request)
    {
		$this->denyAccessUnlessGranted('ROLE_ADMIN', null, 'Only for admins.');

		// tenhle kus jsem sprostě vykopíroval z FOSUSer bundlu
		// takže...
		// až se mě někdo bude ptát třeba
		// jak se tenhle formulář validuje
		//
		// tak...
		//
		// nemám sebemenší tušení :-)
		//
		//
		// ne kecám, je na to automagic config někde ve fosuserbundle
		// http://imgur.com/a/ZkHGt
		//
		// (a takhle vypadá vývoj v Symfony děti)

		/** @var $formFactory \FOS\UserBundle\Form\Factory\FactoryInterface */
		$formFactory = $this->get('fos_user.registration.form.factory');
		/** @var $userManager \FOS\UserBundle\Model\UserManagerInterface */
		$userManager = $this->get('fos_user.user_manager');

		$user = $userManager->createUser();
		$user->setEnabled(true);

		$form = $formFactory->createForm();
		$form->setData($user);

		$form->handleRequest($request);

		if ($form->isSubmitted()) {
			if ($form->isValid()) {

				$defaultRole = $this->getParameter('dalten_web_admin.default_user_role');
				if ($defaultRole) {
					$user->addRole($defaultRole);
				}

				$userManager->updateUser($user);

				$url = $this->generateUrl('webadmin_user_index');
				$response = new RedirectResponse($url);
				return $response;
			}
		}

		return $this->render('DaltenWebAdminBundle:user:new.html.twig', array(
			'form' => $form->createView(),
		));
    }

	public function editAction(Request $request, User $user)
	{
		$this->denyAccessUnlessGranted('ROLE_ADMIN', null, 'Only for admins.');

		/** @var $userManager \FOS\UserBundle\Model\UserManagerInterface */
		$userManager = $this->get('fos_user.user_manager');
		$form = $this->createForm('Dalten\WebAdminBundle\Form\UserEditType', $user);

		$form->handleRequest($request);

		if ($form->isSubmitted()) {
			if ($form->isValid()) {
				$userManager->updateUser($user);

				$url = $this->generateUrl('webadmin_user_index');
				$response = new RedirectResponse($url);
				return $response;
			}
		}

		return $this->render('DaltenWebAdminBundle:user:edit.html.twig', array(
			'edit_form' => $form->createView(),
		));
	}

	public function deleteAction(Request $request, User $user)
	{
		$this->denyAccessUnlessGranted('ROLE_ADMIN', null, 'Only for admins.');

		/** @var $userManager \FOS\UserBundle\Model\UserManagerInterface */
		$userManager = $this->get('fos_user.user_manager');

		$userManager->deleteUser($user);

		return new RedirectResponse($this->generateUrl('webadmin_user_index'));

	}
}
