<?php

namespace Dalten\WebAdminBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ArticleHistory
 *
 * @ORM\Table(name="article_history", indexes={@ORM\Index(name="id_article", columns={"id_article"})})
 * @ORM\MappedSuperclass
 */
class ArticleHistory
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="revision_number", type="integer", nullable=false)
     */
    private $revisionNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="teaser", type="string", length=255, nullable=true)
     */
    private $teaser;

    /**
     * @var string
     *
     * @ORM\Column(name="html", type="text", length=16777215, nullable=true)
     */
    private $html;

    /**
     * @var string
     *
     * @ORM\Column(name="revision_author", type="string", length=255, nullable=false)
     */
    private $revisionAuthor;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="revision_date", type="datetime", nullable=false)
     */
    private $revisionDate;

    /**
     * @var string
     *
     * @ORM\Column(name="old_slug", type="string", length=255, nullable=true)
     */
    private $oldSlug;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_autosave", type="boolean", nullable=false)
     */
    private $isAutosave;

    /**
     * @var \App\FrontBundle\Entity\Article
     *
     * @ORM\ManyToOne(targetEntity="App\FrontBundle\Entity\Article")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_article", referencedColumnName="id", onDelete="CASCADE")
     * })
     */
    private $idArticle;


	/**
	 * Get id
	 *
	 * @return boolean
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Set revisionNumber
	 *
	 * @param integer $revisionNumber
	 * @return ArticleHistory
	 */
	public function setRevisionNumber($revisionNumber)
	{
		$this->revisionNumber = $revisionNumber;

		return $this;
	}

	/**
	 * Get revisionNumber
	 *
	 * @return integer
	 */
	public function getRevisionNumber()
	{
		return $this->revisionNumber;
	}

	/**
	 * Set name
	 *
	 * @param string $name
	 * @return ArticleHistory
	 */
	public function setName($name)
	{
		$this->name = $name;

		return $this;
	}

	/**
	 * Get name
	 *
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * Set teaser
	 *
	 * @param string $teaser
	 * @return ArticleHistory
	 */
	public function setTeaser($teaser)
	{
		$this->teaser = $teaser;

		return $this;
	}

	/**
	 * Get teaser
	 *
	 * @return string
	 */
	public function getTeaser()
	{
		return $this->teaser;
	}

	/**
	 * Set html
	 *
	 * @param string $html
	 * @return ArticleHistory
	 */
	public function setHtml($html)
	{
		$this->html = $html;

		return $this;
	}

	/**
	 * Get html
	 *
	 * @return string
	 */
	public function getHtml()
	{
		return $this->html;
	}

	/**
	 * Set revisionAuthor
	 *
	 * @param string $revisionAuthor
	 * @return ArticleHistory
	 */
	public function setRevisionAuthor($revisionAuthor)
	{
		$this->revisionAuthor = $revisionAuthor;

		return $this;
	}

	/**
	 * Get revisionAuthor
	 *
	 * @return string
	 */
	public function getRevisionAuthor()
	{
		return $this->revisionAuthor;
	}

	/**
	 * Set revisionDate
	 *
	 * @param \DateTime $revisionDate
	 * @return ArticleHistory
	 */
	public function setRevisionDate($revisionDate)
	{
		$this->revisionDate = $revisionDate;

		return $this;
	}

	/**
	 * Get revisionDate
	 *
	 * @return \DateTime
	 */
	public function getRevisionDate()
	{
		return $this->revisionDate;
	}

    public function getOldSlug()
    {
        return $this->oldSlug;
    }

    public function setOldSlug($oldSlug)
    {
        return $this->oldSlug = $oldSlug;
    }

	/**
	 * Set isAutosave
	 *
	 * @param boolean $isAutosave
	 * @return ArticleHistory
	 */
	public function setIsAutosave($isAutosave)
	{
		$this->isAutosave = $isAutosave;

		return $this;
	}

	/**
	 * Get isAutosave
	 *
	 * @return boolean
	 */
	public function getIsAutosave()
	{
		return $this->isAutosave;
	}

	/**
	 * Set idArticle
	 *
	 * @param \App\FrontBundle\Entity\Article $idArticle
	 * @return ArticleHistory
	 */
	public function setIdArticle(\App\FrontBundle\Entity\Article $idArticle = null)
	{
		$this->idArticle = $idArticle;

		return $this;
	}

	/**
	 * Get idArticle
	 *
	 * @return \App\FrontBundle\Entity\Article
	 */
	public function getIdArticle()
	{
		return $this->idArticle;
	}

	public function hasChanges(Article $article)
	{
		return !(
			$this->getName() == $article->getName() &&
			$this->getTeaser() == $article->getTeaser() &&
			$this->getHtml() == $article->getHtml() &&
			$this->getOldSlug() == $article->getOldSlug()
		);
	}
}
