<?php

namespace Dalten\WebAdminBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Translation
 *
 * @ORM\Table(name="article_translation")
 * @ORM\MappedSuperclass
 */
class Translation
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="original_id", type="integer", length=50, nullable=false)
     */
    private $original_id;

    /**
     * @var integer
     *
     * @ORM\Column(name="translated_id", type="integer", length=50, nullable=false)
     */
    private $translated_id;

    /**
     * @var string
     *
     * @ORM\Column(name="language", type="string", length=6, nullable=false)
     */
    private $language;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set original_id
     *
     * @param integer $originalId
     * @return Translation
     */
    public function setOriginalId($originalId)
    {
        $this->original_id = $originalId;

        return $this;
    }

    /**
     * Get original_id
     *
     * @return \int 
     */
    public function getOriginalId()
    {
        return $this->original_id;
    }

    /**
     * Set translated_id
     *
     * @param integer $translatedId
     * @return Translation
     */
    public function setTranslatedId( $translatedId)
    {
        $this->translated_id = $translatedId;

        return $this;
    }

    /**
     * Get translated_id
     *
     * @return \int 
     */
    public function getTranslatedId()
    {
        return $this->translated_id;
    }

    /**
     * Set language
     *
     * @param string $language
     * @return Translation
     */
    public function setLanguage($language)
    {
        $this->language = $language;

        return $this;
    }

    /**
     * Get language
     *
     * @return string 
     */
    public function getLanguage()
    {
        return $this->language;
    }
}
