<?php
namespace Dalten\WebAdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\CallbackTransformer;

class UserEditType extends AbstractType
{
	/**
	 * @param FormBuilderInterface $builder
	 * @param array $options
	 */
	public function buildForm(FormBuilderInterface $builder, array $options)
	{
		$builder
			->add('username', 'text', array('label'=>'Uživatelské jméno', 'read_only'=>true))
			->add('email', 'text', array('label'=>'E-mail', 'read_only'=>true))
			->add('roles', 'textarea', array('label'=>'Role'))
			->add('plain_password', 'text', array('label'=>'Nastavit heslo', 'required'=>false))
		;

		// převádí data z entity do formuláře a naopak
		$builder->get('roles')
			->addModelTransformer(new CallbackTransformer(
				function ($tagsAsArray) {
					// transform the array to a string
					return implode(PHP_EOL, $tagsAsArray);
				},
				function ($tagsAsString) {
					// transform the string back to an array
					return explode(PHP_EOL, $tagsAsString);
				}
			))
		;
	}

	/**
	 * @param OptionsResolver $resolver
	 */
	public function configureOptions(OptionsResolver $resolver)
	{
		$resolver->setDefaults(array(
			'data_class' => 'Dalten\WebAdminBundle\Entity\User'
		));
	}
}