<?php
namespace Dalten\WebAdminBundle\Helper;

use Doctrine\ORM\Tools\Pagination\Paginator;
use Symfony\Bundle\FrameworkBundle\Routing\Router;
use Traversable;

/**
 * Jednoduchá třída na stránkování. Obaluje Doctrine Paginator.
 *
 * @package Dalten\WebAdminBundle\Helper
 */
class Pager implements \IteratorAggregate
{
	/** @var \Doctrine\ORM\Tools\Pagination\Paginator  */
	protected $_paginator;
	protected $_pageSize = 10;
	protected $_currentPage = 1;

	function __construct($dql, $pageSize = 10, $currentPage = 1)
	{
		if (empty($currentPage)) {
			$currentPage = 1;
		}

		$paginator = new Paginator($dql);

		$paginator
			->getQuery()
			->setFirstResult($pageSize * ($currentPage - 1)) // set the offset
			->setMaxResults($pageSize); // set the limit

		$this->_paginator = $paginator;
		$this->_pageSize = $pageSize;
		$this->_currentPage = $currentPage;
	}

	protected function _clamp($min, $current, $max)
	{
		return max($min, min($max, $current));
	}

	protected function _route(Router $router, $route, array $params, $pageParam, $pageNum=1)
	{
		if ($pageNum!=1) {
			$params[$pageParam] = $pageNum;
		}
		return $router->generate($route, $params);
	}

	function render(Router $router, $route, $params=array(), $pageParam='page')
	{
		$totalItems = count($this->_paginator);
		$pagesCount = ceil($totalItems / $this->_pageSize);
		$currentPage = $this->_currentPage;

		if ($pagesCount==1) {
			return '';
		}

		$out = '<nav><ul class="pagination">';

		$out .= '<li '.($currentPage==1 ? 'class="disabled"' : '').'><a href="'.$this->_route($router, $route, $params, $pageParam, $this->_clamp(1, $currentPage-1, $pagesCount)).'">«</a></li>';

		for ($i = 1; $i <= $pagesCount; $i++) {
			$out .= '<li';
			if ($currentPage==$i) {
				$out .= ' class="active" ';
			}
			$out .='><a href="'.$this->_route($router, $route, $params, $pageParam, $i).'">'.$i.'</a></li>';
		}

		$out .= '<li '.($currentPage==$pagesCount ? 'class="disabled"' : '').'><a href="'.$this->_route($router, $route, $params, $pageParam, $this->_clamp(1, $currentPage+1, $pagesCount)).'">»</a></li>';

		$out .= '</ul></nav>';

		return $out;
	}

	/**
	 * (PHP 5 &gt;= 5.0.0)<br/>
	 * Retrieve an external iterator
	 *
	 * @link http://php.net/manual/en/iteratoraggregate.getiterator.php
	 * @return Traversable An instance of an object implementing <b>Iterator</b> or
	 * <b>Traversable</b>
	 */
	public function getIterator()
	{
		return $this->_paginator->getIterator();
	}


}