<?php

namespace Dalten\WebAdminBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class DefaultController extends Controller
{
	public function indexAction()
	{
		return $this->render('DaltenWebAdminBundle:Default:index.html.twig');
	}

	public function fileAdminAction()
	{
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		return $this->render('DaltenWebAdminBundle:Default:fileadmin.html.twig');
	}

	public function configAction(Request $request)
	{
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		$em = $this->getDoctrine()->getManager();
		$repo = $em->getRepository('DaltenWebAdminBundle:ConfigValue');

		$configValues = $repo->findAll();

		if ($request->isMethod('POST')) {
			foreach ($configValues as $configValue) {
				$configName = $configValue->getName();
				if ($request->request->has($configName)) {
					$configValue->setValue($request->request->get($configName));
					$em->persist($configValue);
				}
			}

			$em->flush();

			return $this->redirectToRoute('dalten_web_admin_config');
		}

		return $this->render('DaltenWebAdminBundle:Default:config.html.twig', array(
			'configValues' => $configValues
		));
	}

	public function previewAction(Request $request, $slug)
	{
		if ($request->getQueryString()) {
			$slug .= '?' . $request->getQueryString();
		}

		/** @var  $em */
		$em = $this->getDoctrine()->getManager();

		$menu = $this->get('processor.menuBuilder')->buildTwoLevel();


		if ($slug=='') {
			return $this->render('DaltenWebAdminBundle:Default:preview_next.html.twig', array(
				'content' => array('name'=>'Náhled webu', 'html'=>''),
				'menu' => $menu
			));

		} else {
			$foundArticle = $em->getRepository('DaltenWebAdminBundle:Article')->findOneBy(array('slug'=>$slug));
			if ($foundArticle) {
				return $this->render('DaltenWebAdminBundle:Default:preview_next.html.twig', array(
					'content' => $foundArticle,
					'menu' => $menu
				));
			}

			$foundBlogpost = $em->getRepository('DaltenWebAdminBundle:Blogpost')->findOneBy(array('slug'=>$slug));
			if ($foundBlogpost) {
				return $this->render('DaltenWebAdminBundle:Default:preview_next.html.twig', array(
					'content' => $foundBlogpost,
					'menu' => $menu
				));
			}
		}
		throw $this->createNotFoundException('Nenalezeno = '.$slug);
	}

	public function changedPasswordAction()
	{
		return $this->redirectToRoute('dalten_web_admin_homepage');
	}
}
