<?php

namespace Dalten\WebAdminBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Dalten\WebAdminBundle\Entity\MenuItem;
use Dalten\WebAdminBundle\Form\MenuItemType;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * MenuItem controller.
 *
 */
class MenuItemController extends Controller
{
    /**
     * Lists all MenuItem entities.
     *
     */
    public function indexAction(Request $request)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $em = $this->getDoctrine()->getManager();
		$parentId = $request->get('parent_id');
		$parentItem = null;

		$repo = $em->getRepository('DaltenWebAdminBundle:MenuItem');

		if ($parentId) {
			$parentItem = $repo->findOneBy(array('id'=>$parentId));
		}

		$enabledInfiniteMenu = $this->getParameter('dalten_web_admin.enabled_infinite_menu');

		$submenuVisible = true;
		if ($parentId) {
			$submenuVisible = $enabledInfiniteMenu;
		}

        $menuItems = $repo->findBy(array('parent_id'=>$parentId), array('rank'=>'ASC'));

        return $this->render('DaltenWebAdminBundle:menuitem:index.html.twig', array(
            'menuItems' => $menuItems,
			'parentItem' => $parentItem,
			'submenuVisible' => $submenuVisible
        ));
    }

    /**
     * Creates a new MenuItem entity.
     *
     */
    public function newAction(Request $request)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $menuItem = new MenuItem();

		if ($request->get('parent_id')) {
			$menuItem->setParentId($request->get('parent_id'));
		}

		$form = $this->_createForm($menuItem);
        $form->handleRequest($request);

		$em = $this->getDoctrine()->getManager();
		$repo = $em->getRepository('DaltenWebAdminBundle:MenuItem');

        if ($form->isSubmitted() && $form->isValid()) {

			$rankCount = count($repo->findBy(array('parent_id'=>$menuItem->getParentId())));
			$menuItem->setRank($rankCount + 1);
			$this->_removeUrlForArticle($menuItem);

            $em->persist($menuItem);
            $em->flush();

            return $this->redirectToRoute('webadmin_menuitem_index', array('parent_id' => $menuItem->getParentId()));
        }

        return $this->render('DaltenWebAdminBundle:menuitem:new.html.twig', array(
            'menuItem' => $menuItem,
			'parent' => $repo->findOneBy(array('id'=>$menuItem->getParentId())),
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a MenuItem entity.
     *
     */
    public function showAction(MenuItem $menuItem)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $deleteForm = $this->createDeleteForm($menuItem);

        return $this->render('DaltenWebAdminBundle:menuitem:show.html.twig', array(
            'menuItem' => $menuItem,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing MenuItem entity.
     *
     */
    public function editAction(Request $request, MenuItem $menuItem)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $deleteForm = $this->createDeleteForm($menuItem);
        $editForm = $this->_createForm($menuItem);
		$editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $em = $this->getDoctrine()->getManager();
			$this->_removeUrlForArticle($menuItem);
            $em->persist($menuItem);
            $em->flush();

            return $this->redirectToRoute('webadmin_menuitem_index', array('parent_id' => $menuItem->getParentId()));
        }

        return $this->render('DaltenWebAdminBundle:menuitem:edit.html.twig', array(
            'menuItem' => $menuItem,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    protected function _createForm(MenuItem $menuItem)
	{
		$builder = new MenuItemType();

		$form = $this->createForm($builder, $menuItem);

		return $form;
	}

	/**
	 * Když je vybrán článek, nechceme URL.
	 *
	 * @param MenuItem $menuItem
	 */
	protected function _removeUrlForArticle(MenuItem $menuItem)
	{
		if ($menuItem->getArticle()) {
			$menuItem->setUrl(null);
		}
	}

	/**
	 * Rekurzivně smaže potomky položky menu.
	 *
	 * @param MenuItem $menuItem
	 */
	protected function _removeChildren(MenuItem $menuItem)
	{
		$em = $this->getDoctrine()->getManager();
		$repo = $em->getRepository('DaltenWebAdminBundle:MenuItem');

		$children = $repo->findBy(array('parent_id'=>$menuItem->getId()));

		foreach ($children as $kid) {
			$this->_removeChildren($kid);
			$em->remove($kid);
		}
	}

    /**
     * Deletes a MenuItem entity.
     *
     */
    public function deleteAction(Request $request, MenuItem $menuItem)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $form = $this->createDeleteForm($menuItem);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
			$this->_removeChildren($menuItem);
			$em->remove($menuItem);
            $em->flush();
        }

        return $this->redirectToRoute('webadmin_menuitem_index');
    }

	public function reorderAction(Request $request)
	{
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		$em = $this->getDoctrine()->getManager();
		$repo = $em->getRepository('DaltenWebAdminBundle:MenuItem');

		$order = explode(',', $request->get('order'));

		// projde položky a updatuje rank

		$rank = 0;
		foreach ($order as $itemId) {
			$rank++;
			/** @var MenuItem $item */
			$item = $repo->findOneBy(array('id'=>$itemId));
			$item->setRank($rank);
			$em->persist($item);
		}

		$em->flush();

		return new JsonResponse(array('status' => 'OK'));
	}

    /**
     * Creates a form to delete a MenuItem entity.
     *
     * @param MenuItem $menuItem The MenuItem entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(MenuItem $menuItem)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('webadmin_menuitem_delete', array('id' => $menuItem->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
