<?php

namespace Dalten\WebAdminBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BrokerArticles
 *
 * @ORM\MappedSuperclass
 * @ORM\Table(name="broker_articles")
 */
class BrokerArticles
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="broker_id", type="integer", nullable=false, unique=true)
     */
    private $broker_id;

    /**
     * @var string
     *
     * @ORM\Column(name="services_perex", type="string", nullable=true)
     */
    private $services_perex;

    /**
     * @var string
     *
     * @ORM\Column(name="services", type="text", nullable=true)
     */
    private $services;

    /**
     * @var string
     *
     * @ORM\Column(name="personal_perex", type="string", nullable=true)
     */
    private $personal_perex;

    /**
     * @var string
     *
     * @ORM\Column(name="personal", type="text", nullable=true)
     */
    private $personal;

    /**
     * @var string
     *
     * @ORM\Column(name="phone", type="string", length=20, nullable=true)
     */
    private $phone;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=100, nullable=true)
     */
    private $email;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set services
     *
     * @param string $services
     *
     * @return BrokerArticles
     */
    public function setServices($services)
    {
        $this->services = $services;

        return $this;
    }

    /**
     * Get services
     *
     * @return string
     */
    public function getServices()
    {
        return $this->services;
    }

    /**
     * Set personal
     *
     * @param string $personal
     *
     * @return BrokerArticles
     */
    public function setPersonal($personal)
    {
        $this->personal = $personal;

        return $this;
    }

    /**
     * Get personal
     *
     * @return string
     */
    public function getPersonal()
    {
        return $this->personal;
    }


    /**
     * Set brokerId
     *
     * @param integer $brokerId
     *
     * @return BrokerArticles
     */
    public function setBrokerId($brokerId)
    {
        $this->broker_id = $brokerId;

        return $this;
    }

    /**
     * Get brokerId
     *
     * @return integer
     */
    public function getBrokerId()
    {
        return $this->broker_id;
    }

    /**
     * Set servicesPerex
     *
     * @param string $servicesPerex
     *
     * @return BrokerArticles
     */
    public function setServicesPerex($servicesPerex)
    {
        $this->services_perex = $servicesPerex;

        return $this;
    }

    /**
     * Get servicesPerex
     *
     * @return string
     */
    public function getServicesPerex()
    {
        return $this->services_perex;
    }

    /**
     * Set personalPerex
     *
     * @param string $personalPerex
     *
     * @return BrokerArticles
     */
    public function setPersonalPerex($personalPerex)
    {
        $this->personal_perex = $personalPerex;

        return $this;
    }

    /**
     * Get personalPerex
     *
     * @return string
     */
    public function getPersonalPerex()
    {
        return $this->personal_perex;
    }
}
