<?php

namespace Dalten\WebAdminBundle\Controller;

use Dalten\WebAdminBundle\Entity\Broker;
use Dalten\WebAdminBundle\Entity\BrokerArticles;
use Dalten\WebAdminBundle\Form\BrokerArticlesType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class BrokersController extends Controller
{
    public function indexAction()
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $brokers = $this->getDoctrine()->getRepository('DaltenWebAdminBundle:Broker')->findAll();

        return $this->render('DaltenWebAdminBundle:brokers:index.html.twig', ['brokers' => $brokers]);
    }

    public function editAction(Broker $broker, Request $request)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        /**
         * Entity Broker a BrokerArticles nejsou provázané pomocí Doctrine, protože Broker je totálně zprzněnej,
         * ani foreign key se na něm nedá založit
         */
        $brokerArticles = $this->getDoctrine()->getRepository('DaltenWebAdminBundle:BrokerArticles')->findOneBy([
            'broker_id' => $broker->id
        ]) ?? new BrokerArticles();
        $brokerArticles->setBrokerId($broker->id);

        $form = $this->createForm(BrokerArticlesType::class, $brokerArticles);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($brokerArticles);
            $em->flush();
        }

        $context = [
            'broker' => $broker,
            'form' => $form->createView(),
        ];

        return $this->render('DaltenWebAdminBundle:brokers:edit.html.twig', $context);
    }
}
