<?php

namespace Dalten\WebAdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;


class MenuItemType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'title',
                'Symfony\Component\Form\Extension\Core\Type\TextType',
                ['label' => 'Text', 'constraints' => new NotBlank()]
            )
            ->add(
                'article',
                'Symfony\Bridge\Doctrine\Form\Type\EntityType',
                [
                    'label' => 'Článek',
                    'choice_label' => 'name',
                    'class' => 'DaltenWebAdminBundle:Article',
                    'empty_data' => null,
                    'placeholder' => '== žádný článek ==',
                    'required' => false
                ]
            )
            ->add('url', 'Symfony\Component\Form\Extension\Core\Type\TextType', ['required' => false])
            ->add('parent_id', 'Symfony\Component\Form\Extension\Core\Type\HiddenType');
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Dalten\WebAdminBundle\Entity\MenuItem'
        ));
    }
}
