<?php

namespace Dalten\WebAdminBundle\Form;

use FM\ElfinderBundle\Form\Type\ElFinderType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class ReferenceType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('text', TextareaType::class, ['label' => 'Text reference', 'required' => false])
            ->add('signature', TextType::class, [
                'label' => 'Podpis', 'required' => true, 'constraints' => new NotBlank()
            ])
            ->add('job', TextType::class, [
                'label' => 'Profese/práce', 'required' => false
            ])
            ->add('photo', ElFinderType::class, [
                'label' => 'Fotografie',
                'instance' => 'form',
                'enable' => true,
                'required' => false,
                'attr' => ['class' => 'form-control', 'placeholder' => 'Klikněte zde pro výběr fotografie']
            ])
            ->add('datetime', DateTimeType::class, ['label' => 'Datum a čas přidání reference', 'required' => false])
            ->add('broker', null, ['label' => 'Makléř', 'required' => false])
        ;

        if ($options['translation_languages'] && !empty($options['translation_languages'])) {
            $builder
                ->add('language', ChoiceType::class, [
                    'label' => 'Jazyk reference',
                    'required' => false,
                    'choices_as_values' => false,
                    'empty_value'=>'-- nezařazeno --',
                    'choices'=>$options['translation_languages']
                ]);
        }
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Dalten\WebAdminBundle\Entity\Reference',
            'translation_languages' => false
        ));
    }
}
